/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.chunkupload.internal;

import java.text.DecimalFormat;

public class Utility {
    private static final double KILOBYTES = 1024.0;
    private static final double MEGABYTES = 1048576.0;
    private static final double GIGABYTES = 1.073741824E9;
    private static final DecimalFormat formatter = new DecimalFormat("#,##0.##");

    public static String toByteUnitsString(long bytes) {
        if ((double)bytes < 1024.0) {
            return String.valueOf(formatter.format(bytes)) + " byte/s";
        }
        if ((double)bytes < 1048576.0) {
            double value = (double)bytes / 1024.0;
            return String.valueOf(formatter.format(value)) + " KB";
        }
        if ((double)bytes < 1.073741824E9) {
            double value = (double)bytes / 1048576.0;
            return String.valueOf(formatter.format(value)) + " MB";
        }
        double value = (double)bytes / 1.073741824E9;
        return String.valueOf(formatter.format(value)) + " GB";
    }

    public static String toByteUnitsString(double bytes) {
        if (bytes < 1024.0) {
            return String.valueOf(formatter.format(bytes)) + " byte/s";
        }
        if (bytes < 1048576.0) {
            double value = bytes / 1024.0;
            return String.valueOf(formatter.format(value)) + " KB/s";
        }
        if (bytes < 1.073741824E9) {
            double value = bytes / 1048576.0;
            return String.valueOf(formatter.format(value)) + " MB/s";
        }
        double value = bytes / 1.073741824E9;
        return String.valueOf(formatter.format(value)) + " GB/s";
    }

    public static String toString(long T, int prec) {
        if (prec < 0 || prec > 3) {
            prec = 3;
        }
        long ts = T / 1000L;
        long ms = T % 1000L;
        long h = 0L;
        if (ts >= 360000L) {
            h = ts / 3600L;
            ts %= 3600L;
        }
        long m = 0L;
        if (ts >= 6000L) {
            m = ts / 60L;
            ts %= 60L;
        }
        StringBuffer B = new StringBuffer();
        if (h > 0L) {
            B.append(String.valueOf(h));
            B.append("h ");
        }
        if (m > 0L) {
            B.append(String.valueOf(m));
            B.append("m ");
        }
        B.append(String.valueOf(ts));
        if (prec == 0) {
            B.append("s");
            return B.toString();
        }
        B.append(".");
        switch (prec) {
            case 1: {
                B.append(String.valueOf(ms / 100L));
                break;
            }
            case 2: {
                B.append(String.valueOf(ms / 10L));
                break;
            }
            case 3: {
                B.append(String.valueOf(ms));
            }
        }
        B.append("s");
        return B.toString();
    }

    public static double getCurrentTrasmissionRate(long trasmitted, double time) {
        return (double)trasmitted / time;
    }

    public static double getEstimatedTimeLeft(long totalByteSize, long byteTransmitted, double ctr) {
        return ((double)totalByteSize - (double)byteTransmitted) / ctr;
    }
}

