/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import sun.security.ssl.Alert;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientAuthType;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ClientHello;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLExtensions;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.StatusResponseManager;
import sun.security.ssl.Utilities;
import sun.security.ssl.X509Authentication;

final class CertificateMessage {
    static final SSLConsumer t12HandshakeConsumer = new T12CertificateConsumer();
    static final HandshakeProducer t12HandshakeProducer = new T12CertificateProducer();
    static final SSLConsumer t13HandshakeConsumer = new T13CertificateConsumer();
    static final HandshakeProducer t13HandshakeProducer = new T13CertificateProducer();

    CertificateMessage() {
    }

    private static final class T13CertificateConsumer
    implements SSLConsumer {
        private T13CertificateConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
            handshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE.id);
            T13CertificateMessage t13CertificateMessage = new T13CertificateMessage(handshakeContext, byteBuffer);
            if (handshakeContext.sslConfig.isClientMode) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Consuming server Certificate handshake message", t13CertificateMessage);
                }
                this.onConsumeCertificate((ClientHandshakeContext)connectionContext, t13CertificateMessage);
            } else {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Consuming client Certificate handshake message", t13CertificateMessage);
                }
                this.onConsumeCertificate((ServerHandshakeContext)connectionContext, t13CertificateMessage);
            }
        }

        private void onConsumeCertificate(ServerHandshakeContext serverHandshakeContext, T13CertificateMessage t13CertificateMessage) throws IOException {
            if (t13CertificateMessage.certEntries == null || t13CertificateMessage.certEntries.isEmpty()) {
                serverHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_VERIFY.id);
                if (serverHandshakeContext.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUIRED) {
                    serverHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "Empty client certificate chain");
                } else {
                    return;
                }
            }
            X509Certificate[] x509CertificateArray = T13CertificateConsumer.checkClientCerts(serverHandshakeContext, t13CertificateMessage.certEntries);
            serverHandshakeContext.handshakeCredentials.add(new X509Authentication.X509Credentials(x509CertificateArray[0].getPublicKey(), x509CertificateArray));
            serverHandshakeContext.handshakeSession.setPeerCertificates(x509CertificateArray);
        }

        private void onConsumeCertificate(ClientHandshakeContext clientHandshakeContext, T13CertificateMessage t13CertificateMessage) throws IOException {
            if (t13CertificateMessage.certEntries == null || t13CertificateMessage.certEntries.isEmpty()) {
                clientHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "Empty server certificate chain");
            }
            SSLExtension[] sSLExtensionArray = clientHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.CERTIFICATE);
            for (CertificateEntry certificateEntry : t13CertificateMessage.certEntries) {
                certificateEntry.extensions.consumeOnLoad(clientHandshakeContext, sSLExtensionArray);
            }
            X509Certificate[] x509CertificateArray = T13CertificateConsumer.checkServerCerts(clientHandshakeContext, t13CertificateMessage.certEntries);
            clientHandshakeContext.handshakeCredentials.add(new X509Authentication.X509Credentials(x509CertificateArray[0].getPublicKey(), x509CertificateArray));
            clientHandshakeContext.handshakeSession.setPeerCertificates(x509CertificateArray);
        }

        private static X509Certificate[] checkClientCerts(ServerHandshakeContext serverHandshakeContext, List<CertificateEntry> list) throws IOException {
            Object object;
            Object object2;
            X509Certificate[] x509CertificateArray = new X509Certificate[list.size()];
            try {
                object2 = CertificateFactory.getInstance("X.509");
                int n = 0;
                for (CertificateEntry certificateEntry : list) {
                    x509CertificateArray[n++] = (X509Certificate)((CertificateFactory)object2).generateCertificate(new ByteArrayInputStream(certificateEntry.encoded));
                }
            }
            catch (CertificateException certificateException) {
                serverHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "Failed to parse server certificates", certificateException);
            }
            switch (object2 = x509CertificateArray[0].getPublicKey().getAlgorithm()) {
                case "RSA": 
                case "DSA": 
                case "EC": 
                case "RSASSA-PSS": {
                    object = object2;
                    break;
                }
                default: {
                    object = "UNKNOWN";
                }
            }
            try {
                Object object3 = serverHandshakeContext.sslContext.getX509TrustManager();
                if (object3 instanceof X509ExtendedTrustManager) {
                    if (serverHandshakeContext.conContext.transport instanceof SSLEngine) {
                        SSLEngine sSLEngine = (SSLEngine)((Object)serverHandshakeContext.conContext.transport);
                        ((X509ExtendedTrustManager)object3).checkClientTrusted((X509Certificate[])x509CertificateArray.clone(), (String)object, sSLEngine);
                    } else {
                        SSLSocket sSLSocket = (SSLSocket)((Object)serverHandshakeContext.conContext.transport);
                        ((X509ExtendedTrustManager)object3).checkClientTrusted((X509Certificate[])x509CertificateArray.clone(), (String)object, sSLSocket);
                    }
                } else {
                    throw new CertificateException("Improper X509TrustManager implementation");
                }
                serverHandshakeContext.handshakeSession.setPeerCertificates(x509CertificateArray);
            }
            catch (CertificateException certificateException) {
                serverHandshakeContext.conContext.fatal(Alert.CERTIFICATE_UNKNOWN, certificateException);
            }
            return x509CertificateArray;
        }

        private static X509Certificate[] checkServerCerts(ClientHandshakeContext clientHandshakeContext, List<CertificateEntry> list) throws IOException {
            Object object;
            X509Certificate[] x509CertificateArray = new X509Certificate[list.size()];
            try {
                object = CertificateFactory.getInstance("X.509");
                int n = 0;
                for (CertificateEntry certificateEntry : list) {
                    x509CertificateArray[n++] = (X509Certificate)((CertificateFactory)object).generateCertificate(new ByteArrayInputStream(certificateEntry.encoded));
                }
            }
            catch (CertificateException certificateException) {
                clientHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "Failed to parse server certificates", certificateException);
            }
            object = "UNKNOWN";
            try {
                X509TrustManager x509TrustManager = clientHandshakeContext.sslContext.getX509TrustManager();
                if (x509TrustManager instanceof X509ExtendedTrustManager) {
                    Object object2;
                    if (clientHandshakeContext.conContext.transport instanceof SSLEngine) {
                        object2 = (SSLEngine)((Object)clientHandshakeContext.conContext.transport);
                        ((X509ExtendedTrustManager)x509TrustManager).checkServerTrusted((X509Certificate[])x509CertificateArray.clone(), (String)object, (SSLEngine)object2);
                    } else {
                        object2 = (SSLSocket)((Object)clientHandshakeContext.conContext.transport);
                        ((X509ExtendedTrustManager)x509TrustManager).checkServerTrusted((X509Certificate[])x509CertificateArray.clone(), (String)object, (Socket)object2);
                    }
                } else {
                    throw new CertificateException("Improper X509TrustManager implementation");
                }
                clientHandshakeContext.handshakeSession.setPeerCertificates(x509CertificateArray);
            }
            catch (CertificateException certificateException) {
                clientHandshakeContext.conContext.fatal(T13CertificateConsumer.getCertificateAlert(clientHandshakeContext, certificateException), certificateException);
            }
            return x509CertificateArray;
        }

        private static Alert getCertificateAlert(ClientHandshakeContext clientHandshakeContext, CertificateException certificateException) {
            Alert alert = Alert.CERTIFICATE_UNKNOWN;
            Throwable throwable = certificateException.getCause();
            if (throwable instanceof CertPathValidatorException) {
                CertPathValidatorException certPathValidatorException = (CertPathValidatorException)throwable;
                CertPathValidatorException.Reason reason = certPathValidatorException.getReason();
                if (reason == CertPathValidatorException.BasicReason.REVOKED) {
                    alert = clientHandshakeContext.staplingActive ? Alert.BAD_CERT_STATUS_RESPONSE : Alert.CERTIFICATE_REVOKED;
                } else if (reason == CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS) {
                    alert = clientHandshakeContext.staplingActive ? Alert.BAD_CERT_STATUS_RESPONSE : Alert.CERTIFICATE_UNKNOWN;
                }
            }
            return alert;
        }
    }

    private static final class T13CertificateProducer
    implements HandshakeProducer {
        private T13CertificateProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
            if (handshakeContext.sslConfig.isClientMode) {
                return this.onProduceCertificate((ClientHandshakeContext)connectionContext, handshakeMessage);
            }
            return this.onProduceCertificate((ServerHandshakeContext)connectionContext, handshakeMessage);
        }

        private byte[] onProduceCertificate(ServerHandshakeContext serverHandshakeContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            T13CertificateMessage t13CertificateMessage;
            ClientHello.ClientHelloMessage clientHelloMessage = (ClientHello.ClientHelloMessage)handshakeMessage;
            SSLPossession sSLPossession = T13CertificateProducer.choosePossession(serverHandshakeContext, clientHelloMessage);
            if (sSLPossession == null) {
                serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No available authentication scheme");
                return null;
            }
            if (!(sSLPossession instanceof X509Authentication.X509Possession)) {
                serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No X.509 certificate for server authentication");
            }
            X509Authentication.X509Possession x509Possession = (X509Authentication.X509Possession)sSLPossession;
            X509Certificate[] x509CertificateArray = x509Possession.popCerts;
            if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No X.509 certificate for server authentication");
                return null;
            }
            serverHandshakeContext.handshakePossessions.add(x509Possession);
            serverHandshakeContext.handshakeSession.setLocalPrivateKey(x509Possession.popPrivateKey);
            serverHandshakeContext.handshakeSession.setLocalCertificates(x509CertificateArray);
            try {
                t13CertificateMessage = new T13CertificateMessage((HandshakeContext)serverHandshakeContext, new byte[0], x509CertificateArray);
            }
            catch (CertificateException | SSLException exception) {
                serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Failed to produce server Certificate message", exception);
                return null;
            }
            serverHandshakeContext.stapleParams = StatusResponseManager.processStapling(serverHandshakeContext);
            serverHandshakeContext.staplingActive = serverHandshakeContext.stapleParams != null;
            SSLExtension[] sSLExtensionArray = serverHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.CERTIFICATE, Arrays.asList(ProtocolVersion.PROTOCOLS_OF_13));
            Iterator iterator = t13CertificateMessage.certEntries.iterator();
            while (iterator.hasNext()) {
                CertificateEntry certificateEntry;
                serverHandshakeContext.currentCertEntry = certificateEntry = (CertificateEntry)iterator.next();
                certificateEntry.extensions.produce(serverHandshakeContext, sSLExtensionArray);
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced server Certificate message", t13CertificateMessage);
            }
            t13CertificateMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            return null;
        }

        private static SSLPossession choosePossession(HandshakeContext handshakeContext, ClientHello.ClientHelloMessage clientHelloMessage) throws IOException {
            if (handshakeContext.peerRequestedCertSignSchemes == null || handshakeContext.peerRequestedCertSignSchemes.isEmpty()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("No signature_algorithms(_cert) in ClientHello", new Object[0]);
                }
                return null;
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (SignatureScheme signatureScheme : handshakeContext.peerRequestedCertSignSchemes) {
                if (hashSet.contains(signatureScheme.keyAlgorithm)) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                    SSLLogger.warning("Unsupported authentication scheme: " + signatureScheme.name, new Object[0]);
                    continue;
                }
                if (SignatureScheme.getPreferableAlgorithm(handshakeContext.peerRequestedSignatureSchemes, signatureScheme, handshakeContext.negotiatedProtocol) == null) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.warning("Unable to produce CertificateVerify for signature scheme: " + signatureScheme.name, new Object[0]);
                    }
                    hashSet.add(signatureScheme.keyAlgorithm);
                    continue;
                }
                X509Authentication x509Authentication = X509Authentication.valueOf(signatureScheme);
                if (x509Authentication == null) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.warning("Unsupported authentication scheme: " + signatureScheme.name, new Object[0]);
                    }
                    hashSet.add(signatureScheme.keyAlgorithm);
                    continue;
                }
                SSLPossession sSLPossession = x509Authentication.createPossession(handshakeContext);
                if (sSLPossession == null) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                    SSLLogger.warning("Unavailable authentication scheme: " + signatureScheme.name, new Object[0]);
                    continue;
                }
                return sSLPossession;
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.warning("No available authentication scheme", new Object[0]);
            }
            return null;
        }

        private byte[] onProduceCertificate(ClientHandshakeContext clientHandshakeContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object;
            X509Certificate[] x509CertificateArray;
            ClientHello.ClientHelloMessage clientHelloMessage = (ClientHello.ClientHelloMessage)handshakeMessage;
            SSLPossession sSLPossession = T13CertificateProducer.choosePossession(clientHandshakeContext, clientHelloMessage);
            if (sSLPossession == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("No available client authentication scheme", new Object[0]);
                }
                x509CertificateArray = new X509Certificate[]{};
            } else {
                clientHandshakeContext.handshakePossessions.add(sSLPossession);
                if (!(sSLPossession instanceof X509Authentication.X509Possession)) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.fine("No X.509 certificate for client authentication", new Object[0]);
                    }
                    x509CertificateArray = new X509Certificate[]{};
                } else {
                    object = (X509Authentication.X509Possession)sSLPossession;
                    x509CertificateArray = ((X509Authentication.X509Possession)object).popCerts;
                    clientHandshakeContext.handshakeSession.setLocalPrivateKey(((X509Authentication.X509Possession)object).popPrivateKey);
                }
            }
            if (x509CertificateArray != null && x509CertificateArray.length != 0) {
                clientHandshakeContext.handshakeSession.setLocalCertificates(x509CertificateArray);
            } else {
                clientHandshakeContext.handshakeSession.setLocalCertificates(null);
            }
            try {
                object = new T13CertificateMessage((HandshakeContext)clientHandshakeContext, clientHandshakeContext.certRequestContext, x509CertificateArray);
            }
            catch (CertificateException | SSLException exception) {
                clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Failed to produce client Certificate message", exception);
                return null;
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced client Certificate message", object);
            }
            ((SSLHandshake.HandshakeMessage)object).write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }

    static final class T13CertificateMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] requestContext;
        private final List<CertificateEntry> certEntries;

        T13CertificateMessage(HandshakeContext handshakeContext, byte[] byArray, X509Certificate[] x509CertificateArray) throws SSLException, CertificateException {
            super(handshakeContext);
            this.requestContext = (byte[])byArray.clone();
            this.certEntries = new LinkedList<CertificateEntry>();
            for (X509Certificate x509Certificate : x509CertificateArray) {
                byte[] byArray2 = x509Certificate.getEncoded();
                SSLExtensions sSLExtensions = new SSLExtensions(this);
                this.certEntries.add(new CertificateEntry(byArray2, sSLExtensions));
            }
        }

        T13CertificateMessage(HandshakeContext handshakeContext, byte[] byArray, List<CertificateEntry> list) {
            super(handshakeContext);
            this.requestContext = (byte[])byArray.clone();
            this.certEntries = list;
        }

        T13CertificateMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            if (byteBuffer.remaining() < 4) {
                throw new SSLProtocolException("Invalid Certificate message: insufficient data (length=" + byteBuffer.remaining() + ")");
            }
            this.requestContext = Record.getBytes8(byteBuffer);
            if (byteBuffer.remaining() < 3) {
                throw new SSLProtocolException("Invalid Certificate message: insufficient certificate entries data (length=" + byteBuffer.remaining() + ")");
            }
            int n = Record.getInt24(byteBuffer);
            if (n != byteBuffer.remaining()) {
                throw new SSLProtocolException("Invalid Certificate message: incorrect list length (length=" + n + ")");
            }
            SSLExtension[] sSLExtensionArray = handshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.CERTIFICATE);
            LinkedList<CertificateEntry> linkedList = new LinkedList<CertificateEntry>();
            while (byteBuffer.hasRemaining()) {
                byte[] byArray = Record.getBytes24(byteBuffer);
                if (byArray.length == 0) {
                    throw new SSLProtocolException("Invalid Certificate message: empty cert_data");
                }
                SSLExtensions sSLExtensions = new SSLExtensions(this, byteBuffer, sSLExtensionArray);
                linkedList.add(new CertificateEntry(byArray, sSLExtensions));
            }
            this.certEntries = Collections.unmodifiableList(linkedList);
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE;
        }

        @Override
        public int messageLength() {
            int n = 4 + this.requestContext.length;
            for (CertificateEntry certificateEntry : this.certEntries) {
                n += certificateEntry.getEncodedSize();
            }
            return n;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            int n = 0;
            for (CertificateEntry certificateEntry : this.certEntries) {
                n += certificateEntry.getEncodedSize();
            }
            handshakeOutStream.putBytes8(this.requestContext);
            handshakeOutStream.putInt24(n);
            for (CertificateEntry certificateEntry : this.certEntries) {
                handshakeOutStream.putBytes24(certificateEntry.encoded);
                if (certificateEntry.extensions.length() == 0) {
                    handshakeOutStream.putInt16(0);
                    continue;
                }
                certificateEntry.extensions.send(handshakeOutStream);
            }
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"Certificate\": '{'\n  \"certificate_request_context\": \"{0}\",\n  \"certificate_list\": [{1}\n]\n'}'", Locale.ENGLISH);
            StringBuilder stringBuilder = new StringBuilder(512);
            for (CertificateEntry certificateEntry : this.certEntries) {
                stringBuilder.append(certificateEntry.toString());
            }
            Object[] objectArray = new Object[]{Utilities.toHexString(this.requestContext), Utilities.indent(stringBuilder.toString())};
            return messageFormat.format(objectArray);
        }
    }

    static final class CertificateEntry {
        final byte[] encoded;
        private final SSLExtensions extensions;

        CertificateEntry(byte[] byArray, SSLExtensions sSLExtensions) {
            this.encoded = byArray;
            this.extensions = sSLExtensions;
        }

        private int getEncodedSize() {
            int n = this.extensions.length();
            if (n == 0) {
                n = 2;
            }
            return 3 + this.encoded.length + n;
        }

        public String toString() {
            Object object;
            Object[] objectArray;
            MessageFormat messageFormat = new MessageFormat("\n'{'\n{0}\n  \"extensions\": '{'\n{1}\n  '}'\n'}',", Locale.ENGLISH);
            try {
                objectArray = CertificateFactory.getInstance("X.509");
                object = objectArray.generateCertificate(new ByteArrayInputStream(this.encoded));
            }
            catch (CertificateException certificateException) {
                object = this.encoded;
            }
            objectArray = new Object[]{SSLLogger.toString(object), Utilities.indent(this.extensions.toString(), "    ")};
            return messageFormat.format(objectArray);
        }
    }

    static final class T12CertificateConsumer
    implements SSLConsumer {
        private T12CertificateConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
            handshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE.id);
            T12CertificateMessage t12CertificateMessage = new T12CertificateMessage(handshakeContext, byteBuffer);
            if (handshakeContext.sslConfig.isClientMode) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Consuming server Certificate handshake message", t12CertificateMessage);
                }
                this.onCertificate((ClientHandshakeContext)connectionContext, t12CertificateMessage);
            } else {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Consuming client Certificate handshake message", t12CertificateMessage);
                }
                this.onCertificate((ServerHandshakeContext)connectionContext, t12CertificateMessage);
            }
        }

        private void onCertificate(ServerHandshakeContext serverHandshakeContext, T12CertificateMessage t12CertificateMessage) throws IOException {
            List<byte[]> list = t12CertificateMessage.encodedCertChain;
            if (list == null || list.isEmpty()) {
                serverHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_VERIFY.id);
                if (serverHandshakeContext.sslConfig.clientAuthType != ClientAuthType.CLIENT_AUTH_REQUESTED) {
                    serverHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "Empty server certificate chain");
                } else {
                    return;
                }
            }
            X509Certificate[] x509CertificateArray = new X509Certificate[list.size()];
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                int n = 0;
                for (byte[] byArray : list) {
                    x509CertificateArray[n++] = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                }
            }
            catch (CertificateException certificateException) {
                serverHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "Failed to parse server certificates", certificateException);
            }
            T12CertificateConsumer.checkClientCerts(serverHandshakeContext, x509CertificateArray);
            serverHandshakeContext.handshakeCredentials.add(new X509Authentication.X509Credentials(x509CertificateArray[0].getPublicKey(), x509CertificateArray));
            serverHandshakeContext.handshakeSession.setPeerCertificates(x509CertificateArray);
        }

        private void onCertificate(ClientHandshakeContext clientHandshakeContext, T12CertificateMessage t12CertificateMessage) throws IOException {
            Object object;
            List<byte[]> list = t12CertificateMessage.encodedCertChain;
            if (list == null || list.isEmpty()) {
                clientHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "Empty server certificate chain");
            }
            X509Certificate[] x509CertificateArray = new X509Certificate[list.size()];
            try {
                object = CertificateFactory.getInstance("X.509");
                int n = 0;
                for (byte[] byArray : list) {
                    x509CertificateArray[n++] = (X509Certificate)((CertificateFactory)object).generateCertificate(new ByteArrayInputStream(byArray));
                }
            }
            catch (CertificateException certificateException) {
                clientHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "Failed to parse server certificates", certificateException);
            }
            if (!(clientHandshakeContext.reservedServerCerts == null || clientHandshakeContext.handshakeSession.useExtendedMasterSecret || (object = clientHandshakeContext.sslConfig.identificationProtocol) != null && ((String)object).length() != 0 || T12CertificateConsumer.isIdentityEquivalent(x509CertificateArray[0], clientHandshakeContext.reservedServerCerts[0]))) {
                clientHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "server certificate change is restricted during renegotiation");
            }
            if (clientHandshakeContext.staplingActive) {
                clientHandshakeContext.deferredCerts = x509CertificateArray;
            } else {
                T12CertificateConsumer.checkServerCerts(clientHandshakeContext, x509CertificateArray);
            }
            clientHandshakeContext.handshakeCredentials.add(new X509Authentication.X509Credentials(x509CertificateArray[0].getPublicKey(), x509CertificateArray));
            clientHandshakeContext.handshakeSession.setPeerCertificates(x509CertificateArray);
        }

        private static boolean isIdentityEquivalent(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Collection<List<?>> collection;
            Collection<List<?>> collection2;
            block9: {
                block8: {
                    if (x509Certificate.equals(x509Certificate2)) {
                        return true;
                    }
                    collection2 = null;
                    try {
                        collection2 = x509Certificate.getSubjectAlternativeNames();
                    }
                    catch (CertificateParsingException certificateParsingException) {
                        if (!SSLLogger.isOn || !SSLLogger.isOn("handshake")) break block8;
                        SSLLogger.fine("Attempt to obtain subjectAltNames extension failed!", new Object[0]);
                    }
                }
                collection = null;
                try {
                    collection = x509Certificate2.getSubjectAlternativeNames();
                }
                catch (CertificateParsingException certificateParsingException) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("handshake")) break block9;
                    SSLLogger.fine("Attempt to obtain subjectAltNames extension failed!", new Object[0]);
                }
            }
            if (collection2 != null && collection != null) {
                object4 = T12CertificateConsumer.getSubjectAltNames(collection2, 7);
                object3 = T12CertificateConsumer.getSubjectAltNames(collection, 7);
                if (object4 != null && object3 != null && T12CertificateConsumer.isEquivalent((Collection<String>)object4, (Collection<String>)object3)) {
                    return true;
                }
                object2 = T12CertificateConsumer.getSubjectAltNames(collection2, 2);
                object = T12CertificateConsumer.getSubjectAltNames(collection, 2);
                if (object2 != null && object != null && T12CertificateConsumer.isEquivalent((Collection<String>)object2, (Collection<String>)object)) {
                    return true;
                }
            }
            object4 = x509Certificate.getSubjectX500Principal();
            object3 = x509Certificate2.getSubjectX500Principal();
            object2 = x509Certificate.getIssuerX500Principal();
            object = x509Certificate2.getIssuerX500Principal();
            return !((X500Principal)object4).getName().isEmpty() && !((X500Principal)object3).getName().isEmpty() && ((X500Principal)object4).equals(object3) && ((X500Principal)object2).equals(object);
        }

        private static Collection<String> getSubjectAltNames(Collection<List<?>> collection, int n) {
            HashSet<String> hashSet = null;
            for (List<?> list : collection) {
                String string;
                int n2 = (Integer)list.get(0);
                if (n2 != n || (string = (String)list.get(1)) == null || string.isEmpty()) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<String>(collection.size());
                }
                hashSet.add(string);
            }
            return hashSet;
        }

        private static boolean isEquivalent(Collection<String> collection, Collection<String> collection2) {
            for (String string : collection) {
                for (String string2 : collection2) {
                    if (!string.equalsIgnoreCase(string2)) continue;
                    return true;
                }
            }
            return false;
        }

        static void checkServerCerts(ClientHandshakeContext clientHandshakeContext, X509Certificate[] x509CertificateArray) throws IOException {
            X509TrustManager x509TrustManager = clientHandshakeContext.sslContext.getX509TrustManager();
            String string = clientHandshakeContext.negotiatedCipherSuite.keyExchange == CipherSuite.KeyExchange.K_RSA_EXPORT || clientHandshakeContext.negotiatedCipherSuite.keyExchange == CipherSuite.KeyExchange.K_DHE_RSA_EXPORT ? CipherSuite.KeyExchange.K_RSA.name : clientHandshakeContext.negotiatedCipherSuite.keyExchange.name;
            try {
                if (x509TrustManager instanceof X509ExtendedTrustManager) {
                    if (clientHandshakeContext.conContext.transport instanceof SSLEngine) {
                        SSLEngine sSLEngine = (SSLEngine)((Object)clientHandshakeContext.conContext.transport);
                        ((X509ExtendedTrustManager)x509TrustManager).checkServerTrusted((X509Certificate[])x509CertificateArray.clone(), string, sSLEngine);
                    } else {
                        SSLSocket sSLSocket = (SSLSocket)((Object)clientHandshakeContext.conContext.transport);
                        ((X509ExtendedTrustManager)x509TrustManager).checkServerTrusted((X509Certificate[])x509CertificateArray.clone(), string, sSLSocket);
                    }
                } else {
                    throw new CertificateException("Improper X509TrustManager implementation");
                }
                clientHandshakeContext.handshakeSession.setPeerCertificates(x509CertificateArray);
            }
            catch (CertificateException certificateException) {
                clientHandshakeContext.conContext.fatal(T12CertificateConsumer.getCertificateAlert(clientHandshakeContext, certificateException), certificateException);
            }
        }

        private static void checkClientCerts(ServerHandshakeContext serverHandshakeContext, X509Certificate[] x509CertificateArray) throws IOException {
            block14: {
                String string;
                X509TrustManager x509TrustManager = serverHandshakeContext.sslContext.getX509TrustManager();
                PublicKey publicKey = x509CertificateArray[0].getPublicKey();
                String string2 = publicKey.getAlgorithm();
                switch (string2) {
                    case "RSA": 
                    case "DSA": 
                    case "EC": 
                    case "RSASSA-PSS": {
                        string = string2;
                        break;
                    }
                    default: {
                        string = "UNKNOWN";
                    }
                }
                try {
                    if (x509TrustManager instanceof X509ExtendedTrustManager) {
                        Object object;
                        if (serverHandshakeContext.conContext.transport instanceof SSLEngine) {
                            object = (SSLEngine)((Object)serverHandshakeContext.conContext.transport);
                            ((X509ExtendedTrustManager)x509TrustManager).checkClientTrusted((X509Certificate[])x509CertificateArray.clone(), string, (SSLEngine)object);
                        } else {
                            object = (SSLSocket)((Object)serverHandshakeContext.conContext.transport);
                            ((X509ExtendedTrustManager)x509TrustManager).checkClientTrusted((X509Certificate[])x509CertificateArray.clone(), string, (Socket)object);
                        }
                        break block14;
                    }
                    throw new CertificateException("Improper X509TrustManager implementation");
                }
                catch (CertificateException certificateException) {
                    serverHandshakeContext.conContext.fatal(Alert.CERTIFICATE_UNKNOWN, certificateException);
                }
            }
        }

        private static Alert getCertificateAlert(ClientHandshakeContext clientHandshakeContext, CertificateException certificateException) {
            Alert alert = Alert.CERTIFICATE_UNKNOWN;
            Throwable throwable = certificateException.getCause();
            if (throwable instanceof CertPathValidatorException) {
                CertPathValidatorException certPathValidatorException = (CertPathValidatorException)throwable;
                CertPathValidatorException.Reason reason = certPathValidatorException.getReason();
                if (reason == CertPathValidatorException.BasicReason.REVOKED) {
                    alert = clientHandshakeContext.staplingActive ? Alert.BAD_CERT_STATUS_RESPONSE : Alert.CERTIFICATE_REVOKED;
                } else if (reason == CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS) {
                    alert = clientHandshakeContext.staplingActive ? Alert.BAD_CERT_STATUS_RESPONSE : Alert.CERTIFICATE_UNKNOWN;
                } else if (reason == CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED) {
                    alert = Alert.UNSUPPORTED_CERTIFICATE;
                } else if (reason == CertPathValidatorException.BasicReason.EXPIRED) {
                    alert = Alert.CERTIFICATE_EXPIRED;
                } else if (reason == CertPathValidatorException.BasicReason.INVALID_SIGNATURE || reason == CertPathValidatorException.BasicReason.NOT_YET_VALID) {
                    alert = Alert.BAD_CERTIFICATE;
                }
            }
            return alert;
        }
    }

    private static final class T12CertificateProducer
    implements HandshakeProducer {
        private T12CertificateProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
            if (handshakeContext.sslConfig.isClientMode) {
                return this.onProduceCertificate((ClientHandshakeContext)connectionContext, handshakeMessage);
            }
            return this.onProduceCertificate((ServerHandshakeContext)connectionContext, handshakeMessage);
        }

        private byte[] onProduceCertificate(ServerHandshakeContext serverHandshakeContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            X509Authentication.X509Possession x509Possession = null;
            for (SSLPossession sSLPossession : serverHandshakeContext.handshakePossessions) {
                if (!(sSLPossession instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)sSLPossession;
                break;
            }
            if (x509Possession == null) {
                serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "No expected X.509 certificate for server authentication");
                return null;
            }
            serverHandshakeContext.handshakeSession.setLocalPrivateKey(x509Possession.popPrivateKey);
            serverHandshakeContext.handshakeSession.setLocalCertificates(x509Possession.popCerts);
            T12CertificateMessage t12CertificateMessage = new T12CertificateMessage((HandshakeContext)serverHandshakeContext, x509Possession.popCerts);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced server Certificate handshake message", t12CertificateMessage);
            }
            t12CertificateMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            return null;
        }

        private byte[] onProduceCertificate(ClientHandshakeContext clientHandshakeContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            X509Authentication.X509Possession x509Possession = null;
            for (SSLPossession sSLPossession : clientHandshakeContext.handshakePossessions) {
                if (!(sSLPossession instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)sSLPossession;
                break;
            }
            if (x509Possession == null) {
                if (clientHandshakeContext.negotiatedProtocol.useTLS10PlusSpec()) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.fine("No X.509 certificate for client authentication, use empty Certificate message instead", new Object[0]);
                    }
                    x509Possession = new X509Authentication.X509Possession(null, new X509Certificate[0]);
                } else {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.fine("No X.509 certificate for client authentication, send a no_certificate alert", new Object[0]);
                    }
                    clientHandshakeContext.conContext.warning(Alert.NO_CERTIFICATE);
                    return null;
                }
            }
            clientHandshakeContext.handshakeSession.setLocalPrivateKey(x509Possession.popPrivateKey);
            if (x509Possession.popCerts != null && x509Possession.popCerts.length != 0) {
                clientHandshakeContext.handshakeSession.setLocalCertificates(x509Possession.popCerts);
            } else {
                clientHandshakeContext.handshakeSession.setLocalCertificates(null);
            }
            T12CertificateMessage t12CertificateMessage = new T12CertificateMessage((HandshakeContext)clientHandshakeContext, x509Possession.popCerts);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced client Certificate handshake message", t12CertificateMessage);
            }
            t12CertificateMessage.write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }

    static final class T12CertificateMessage
    extends SSLHandshake.HandshakeMessage {
        final List<byte[]> encodedCertChain;

        T12CertificateMessage(HandshakeContext handshakeContext, X509Certificate[] x509CertificateArray) throws SSLException {
            super(handshakeContext);
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>(x509CertificateArray.length);
            for (X509Certificate x509Certificate : x509CertificateArray) {
                try {
                    arrayList.add(x509Certificate.getEncoded());
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    handshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Could not encode certificate (" + x509Certificate.getSubjectX500Principal() + ")", certificateEncodingException);
                    break;
                }
            }
            this.encodedCertChain = arrayList;
        }

        T12CertificateMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            int n = Record.getInt24(byteBuffer);
            if (n > byteBuffer.remaining()) {
                handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Error parsing certificate message:no sufficient data");
            }
            if (n > 0) {
                LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
                while (n > 0) {
                    byte[] byArray = Record.getBytes24(byteBuffer);
                    n -= 3 + byArray.length;
                    linkedList.add(byArray);
                }
                this.encodedCertChain = linkedList;
            } else {
                this.encodedCertChain = Collections.emptyList();
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE;
        }

        @Override
        public int messageLength() {
            int n = 3;
            for (byte[] byArray : this.encodedCertChain) {
                n += byArray.length + 3;
            }
            return n;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            int n = 0;
            for (byte[] byArray : this.encodedCertChain) {
                n += byArray.length + 3;
            }
            handshakeOutStream.putInt24(n);
            for (byte[] byArray : this.encodedCertChain) {
                handshakeOutStream.putBytes24(byArray);
            }
        }

        public String toString() {
            int n;
            Object object;
            if (this.encodedCertChain.isEmpty()) {
                return "\"Certificates\": <empty list>";
            }
            Object[] objectArray = new Object[this.encodedCertChain.size()];
            try {
                object = CertificateFactory.getInstance("X.509");
                n = 0;
                for (byte[] byArray : this.encodedCertChain) {
                    Object object2;
                    try {
                        object2 = (X509Certificate)((CertificateFactory)object).generateCertificate(new ByteArrayInputStream(byArray));
                    }
                    catch (CertificateException certificateException) {
                        object2 = byArray;
                    }
                    objectArray[n++] = object2;
                }
            }
            catch (CertificateException certificateException) {
                n = 0;
                for (byte[] byArray : this.encodedCertChain) {
                    objectArray[n++] = byArray;
                }
            }
            object = new MessageFormat("\"Certificates\": [\n{0}\n]", Locale.ENGLISH);
            Object[] objectArray2 = new Object[]{SSLLogger.toString(objectArray)};
            return ((Format)object).format(objectArray2);
        }
    }
}

