/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.EncryptedContentInfo;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.pkcs.pkcs7.SignedData;
import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.pkcs.pkcs7.d;
import iaik.utils.CryptoUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SignedAndEnvelopedData
extends SignedData
implements d,
Content {
    static /* synthetic */ Class d;
    SecretKey a;
    EncryptedContentInfo c;
    RecipientInfo[] b;

    public void verify(PublicKey publicKey, int n2) throws SignatureException {
        if (n2 < 0 || n2 >= this.signer_infos.size()) {
            throw new SignatureException("SignerInfo does not exist. Wrong index.");
        }
        SignerInfo signerInfo = (SignerInfo)this.signer_infos.elementAt(n2);
        ASN1Type[] aSN1TypeArray = signerInfo.getAuthenticatedAttributes();
        try {
            Object object;
            byte[] byArray;
            AlgorithmID algorithmID = signerInfo.getDigestAlgorithm();
            byte[] byArray2 = this.getMessageDigest(algorithmID);
            if (aSN1TypeArray != null) {
                byArray = this.getSignedDigest(n2);
                if (!CryptoUtils.equalsBlock(byArray2, byArray)) {
                    throw new SignatureException("Signature verification error!");
                }
                object = algorithmID.getMessageDigestInstance();
                byArray2 = ((MessageDigest)object).digest(DerCoder.encode(ASN.createSetOf(aSN1TypeArray)));
            }
            object = signerInfo.f;
            AlgorithmID algorithmID2 = this.c.getContentEncryptionAlgorithm();
            IvParameterSpec ivParameterSpec = new IvParameterSpec((byte[])algorithmID2.getParameter().getValue());
            Cipher cipher = algorithmID2.getCipherInstance();
            cipher.init(2, (Key)this.a, ivParameterSpec, null);
            signerInfo.f = cipher.doFinal(signerInfo.f);
            byArray = signerInfo.getDigest(publicKey);
            signerInfo.f = (byte[])object;
            if (!CryptoUtils.equalsBlock(byArray2, byArray)) {
                throw new SignatureException("Signature verification error!");
            }
        }
        catch (Exception exception) {
            throw new SignatureException("Error verifying the signature: " + exception.getMessage());
        }
    }

    public String toString(boolean bl) {
        int n2;
        AlgorithmID[] algorithmIDArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version + "\n");
        if (this.b.length > 0) {
            int n3 = 0;
            while (n3 < this.b.length) {
                stringBuffer.append("\nRecipientInfo " + (n3 + 1) + ":{\n");
                stringBuffer.append(this.b[n3].toString());
                stringBuffer.append("\n}");
                ++n3;
            }
        }
        if ((algorithmIDArray = ((SignedDataStream)this).b.a()).length > 0) {
            stringBuffer.append("digestAlgorithms: ");
            n2 = 0;
            while (n2 < algorithmIDArray.length) {
                stringBuffer.append(String.valueOf(algorithmIDArray[n2].getName()) + ",");
                ++n2;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nEncryptedContentInfo: {\n");
        stringBuffer.append(String.valueOf(this.c.toString()) + "}");
        stringBuffer.append("\n\n");
        if (this.certificates != null) {
            stringBuffer.append("certificates: " + this.certificates.length + "\n");
        }
        if (this.crls != null) {
            stringBuffer.append("crls: " + this.crls.length + "\n");
        }
        if (bl) {
            n2 = 1;
            Enumeration enumeration = this.signer_infos.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("signerInfo " + n2 + ": {\n");
                stringBuffer.append(String.valueOf(((SignerInfo)enumeration.nextElement()).toString(true)) + "}");
                ++n2;
            }
        } else {
            stringBuffer.append("signerInfos: " + this.signer_infos.size() + "\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        int n3 = 0;
        while (n3 < this.b.length) {
            this.b[n3].encryptKey(this.a);
            ++n3;
        }
        if (this.signer_infos == null) {
            throw new PKCSException("No SignerInfo specified!");
        }
        this.c.setBlockSize(n2);
        SEQUENCE sEQUENCE = new SEQUENCE(n2 > 0);
        try {
            sEQUENCE.addComponent(new INTEGER(this.version));
            if (this.version == 2) {
                Object object;
                sEQUENCE.addComponent(ASN.createSequenceOf(this.b));
                sEQUENCE.addComponent(ASN.createSequenceOf(((SignedDataStream)this).b.a()));
                sEQUENCE.addComponent(this.c.toASN1Object());
                if (this.certificates != null) {
                    object = ASN.createSequenceOf(this.certificates);
                    sEQUENCE.addComponent(new CON_SPEC(2, (ASN1Object)object, true));
                }
                if (this.crls != null) {
                    object = ASN.createSequenceOf(this.crls);
                    sEQUENCE.addComponent(new CON_SPEC(3, (ASN1Object)object, true));
                }
                object = this.signer_infos.elements();
                while (object.hasMoreElements()) {
                    ((SignerInfo)object.nextElement()).a = 2;
                }
                sEQUENCE.addComponent(ASN.createSequenceOf(this.signer_infos));
            } else {
                ASN1Object aSN1Object;
                sEQUENCE.addComponent(ASN.createSetOf(this.b));
                sEQUENCE.addComponent(ASN.createSetOf(((SignedDataStream)this).b.a()));
                sEQUENCE.addComponent(this.c.toASN1Object());
                if (this.certificates != null) {
                    aSN1Object = ASN.createSetOf(this.certificates);
                    sEQUENCE.addComponent(new CON_SPEC(0, aSN1Object, true));
                }
                if (this.crls != null) {
                    aSN1Object = ASN.createSetOf(this.crls);
                    sEQUENCE.addComponent(new CON_SPEC(1, aSN1Object, true));
                }
                sEQUENCE.addComponent(ASN.createSetOf(this.signer_infos));
            }
        }
        catch (CodingException codingException) {
            throw new PKCSException(codingException.toString());
        }
        return sEQUENCE;
    }

    public void setupCipher(PrivateKey privateKey, int n2) throws InvalidKeyException, NoSuchAlgorithmException, PKCSException {
        this.a = this.b[n2].decryptKey(privateKey);
        this.c.setupCipher(this.a);
        ((SignedData)this).b = this.c.getContent();
        this.setupMessageDigests();
    }

    public void setRecipientInfos(RecipientInfo[] recipientInfoArray) {
        this.b = recipientInfoArray;
    }

    public RecipientInfo[] getRecipientInfos() {
        return this.b;
    }

    public InputStream getInputStream() {
        return this.c.getInputStream();
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.c;
    }

    public ObjectID getContentType() {
        return ObjectID.pkcs7_signedAndEnvelopedData;
    }

    public byte[] getContent() {
        return this.c.getContent();
    }

    public void decode(InputStream inputStream) throws PKCSParsingException, IOException {
        ((SignedDataStream)this).a = false;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        this.this_object = ((DerInputStream)inputStream).readSequence();
        this.version = this.this_object.readInteger().intValue();
        try {
            this.b = (RecipientInfo[])ASN.parseSequenceOf(DerCoder.decode(this.this_object), d != null ? d : (d = SignedDataStream.a("iaik.pkcs.pkcs7.RecipientInfo")));
            ((SignedDataStream)this).b.a((AlgorithmID[])ASN.parseSequenceOf(DerCoder.decode(this.this_object), SignedDataStream.d != null ? SignedDataStream.d : (SignedDataStream.d = SignedDataStream.a("iaik.asn1.structures.AlgorithmID"))));
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException("Error parsing recipient infos!");
        }
        this.c = new EncryptedContentInfo();
        this.c.a = this.version - 1;
        this.c.decode(this.this_object);
        this.content_type = this.c.getContentType();
        this.notifyEOF();
    }

    public void decode(ASN1Object aSN1Object) throws PKCSParsingException {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode(aSN1Object)));
            return;
        }
        catch (IOException iOException) {
            throw new PKCSParsingException(iOException.getMessage());
        }
    }

    public void addRecipientInfo(RecipientInfo recipientInfo) {
        if (recipientInfo == null) {
            return;
        }
        if (this.b == null) {
            this.b = new RecipientInfo[]{recipientInfo};
            return;
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[this.b.length + 1];
        System.arraycopy(this.b, 0, recipientInfoArray, 0, this.b.length);
        recipientInfoArray[this.b.length] = recipientInfo;
        this.b = recipientInfoArray;
    }

    public SignedAndEnvelopedData(byte[] byArray, AlgorithmID algorithmID, int n2) throws NoSuchAlgorithmException {
        this();
        ((SignedData)this).b = byArray;
        this.content_type = ObjectID.pkcs7_data;
        this.c = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
        if (n2 == 2) {
            this.version = 2;
            this.c.a = 1;
        } else if (n2 != 1) {
            throw new IllegalArgumentException("Invalid version number: " + n2);
        }
        this.a = this.c.setupCipher(algorithmID);
    }

    public SignedAndEnvelopedData(byte[] byArray, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        this();
        ((SignedData)this).b = byArray;
        this.content_type = ObjectID.pkcs7_data;
        this.c = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
        this.a = this.c.setupCipher(algorithmID);
    }

    public SignedAndEnvelopedData(InputStream inputStream) throws IOException, PKCSParsingException {
        this();
        this.decode(inputStream);
    }

    public SignedAndEnvelopedData(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.decode(aSN1Object);
    }

    protected SignedAndEnvelopedData() {
        this.version = 1;
    }
}

