/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.SDSEncodeListener;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerInfo;
import iaik.cms.attributes.CounterSignature;
import iaik.cms.attributes.SigningTime;
import iaik.x509.X509Certificate;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.Date;

public class CounterSignatureListener
extends SDSEncodeListener {
    X509Certificate certOfSignerToBeCounterSigned_;
    AlgorithmID signatureAlg_ = AlgorithmID.rsaEncryption;
    AlgorithmID digestAlg_;
    PrivateKey privateKey_;
    CertificateIdentifier counterSigner_;

    public void setCertOfSignerToBeCounterSigned(X509Certificate x509Certificate) {
        this.certOfSignerToBeCounterSigned_ = x509Certificate;
    }

    private static int a(X509Certificate x509Certificate, SignedDataStream signedDataStream) {
        SignerInfo[] signerInfoArray = signedDataStream.getSignerInfos();
        if (signerInfoArray != null) {
            int n = 0;
            while (n < signerInfoArray.length) {
                CertificateIdentifier certificateIdentifier = signerInfoArray[n].getSignerIdentifier();
                if (certificateIdentifier.identifiesCert(x509Certificate)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public X509Certificate getCertOfSignerToBeCounterSigned() {
        return this.certOfSignerToBeCounterSigned_;
    }

    private void a(SignerInfo signerInfo) throws CMSException, SignatureException {
        try {
            CounterSignature counterSignature = new CounterSignature(this.counterSigner_, this.digestAlg_, this.signatureAlg_, this.privateKey_);
            Attribute[] attributeArray = new Attribute[]{new Attribute((AttributeValue)new SigningTime(new Date()))};
            counterSignature.setSignedAttributes(attributeArray);
            counterSignature.counterSign(signerInfo);
            Attribute[] attributeArray2 = new Attribute[]{new Attribute((AttributeValue)counterSignature)};
            signerInfo.addUnsignedAttributes(attributeArray2);
            return;
        }
        catch (CodingException codingException) {
            throw new CMSException("Error adding CounterSignature attribute: " + codingException.toString());
        }
    }

    protected void beforeComputeSignature(SignedDataStream signedDataStream) throws CMSException {
    }

    protected void afterComputeSignature(SignedDataStream signedDataStream) throws CMSException {
        if (this.certOfSignerToBeCounterSigned_ != null) {
            int n = CounterSignatureListener.a(this.certOfSignerToBeCounterSigned_, signedDataStream);
            if (n == -1) {
                throw new CMSException("Cannot counter sign " + this.certOfSignerToBeCounterSigned_.getSubjectDN() + ": No SignerInfo found!");
            }
            try {
                signedDataStream.verify(n);
                this.a(signedDataStream.getSignerInfos()[n]);
                return;
            }
            catch (SignatureException signatureException) {
                throw new CMSException("Signature verification ERROR from signer: " + this.certOfSignerToBeCounterSigned_.getSubjectDN() + signatureException.getMessage());
            }
        }
        SignerInfo[] signerInfoArray = signedDataStream.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            try {
                signedDataStream.verify(n);
                this.a(signerInfoArray[n]);
            }
            catch (SignatureException signatureException) {
                throw new CMSException("Signature verification ERROR from signer: " + signerInfoArray[n].getSignerIdentifier() + signatureException.getMessage());
            }
            ++n;
        }
    }

    public CounterSignatureListener(CertificateIdentifier certificateIdentifier, AlgorithmID algorithmID, PrivateKey privateKey) {
        this();
        this.counterSigner_ = certificateIdentifier;
        this.digestAlg_ = algorithmID;
        this.privateKey_ = privateKey;
    }

    public CounterSignatureListener(CertificateIdentifier certificateIdentifier, AlgorithmID algorithmID, AlgorithmID algorithmID2, PrivateKey privateKey) {
        this(certificateIdentifier, algorithmID, privateKey);
        if (algorithmID2 != null) {
            this.signatureAlg_ = algorithmID2;
        }
    }

    CounterSignatureListener() {
    }
}

