/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.applet2.preloader.CancelException;
import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.CanceledDownloadException;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpDownload;
import com.sun.deploy.net.HttpDownloadListener;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

final class HttpDownloadHelper
implements HttpDownload {
    private static final int BUF_SIZE = 32768;
    private static final int BUFFER_SIZE = 8192;
    private static final String JAR_FILE_EXT = ".jar";
    private static final String JARJAR_FILE_EXT = ".jarjar";
    private static final String META_FILE_DIR = "meta-inf/";
    private HttpRequest _httpRequest;
    private static int jarCompression = -1;

    public HttpDownloadHelper(HttpRequest httpRequest) {
        this._httpRequest = httpRequest;
    }

    private static int getJarCompressionLevel() {
        if (jarCompression == -1) {
            String string = Config.getStringProperty("deployment.cache.jarcompression");
            string = string.trim();
            try {
                jarCompression = Integer.valueOf(string);
                if (jarCompression < 0 || jarCompression > 9) {
                    jarCompression = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                jarCompression = 0;
            }
        }
        return jarCompression;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void download(int n, URL uRL, InputStream inputStream, String string, File file, final HttpDownloadListener httpDownloadListener, int n2) throws CanceledDownloadException, IOException {
        boolean bl;
        ZipOutputStream zipOutputStream;
        OutputStream outputStream;
        int n3;
        block40: {
            ZipInputStream zipInputStream;
            block39: {
                n3 = n;
                if (httpDownloadListener != null) {
                    httpDownloadListener.downloadProgress(0, n3);
                }
                if (Trace.isEnabled(TraceLevel.NETWORK)) {
                    Trace.println(ResourceManager.getString("httpDownloadHelper.doingDownload", uRL == null ? "" : uRL.toString(), n, string), TraceLevel.NETWORK);
                }
                outputStream = null;
                zipOutputStream = null;
                zipInputStream = null;
                ZipInputStream zipInputStream2 = null;
                bl = false;
                try {
                    try {
                        if (string != null && string.compareTo("pack200-gzip") == 0 && DownloadEngine.isPack200Supported()) {
                            Pack200.Unpacker unpacker = Pack200.newUnpacker();
                            unpacker.addPropertyChangeListener(new PropertyChangeListener(){

                                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                    if (httpDownloadListener != null && propertyChangeEvent.getPropertyName().compareTo("unpack.progress") == 0) {
                                        String string = (String)propertyChangeEvent.getNewValue();
                                        int n = string != null ? Integer.parseInt(string) : 0;
                                        try {
                                            httpDownloadListener.downloadProgress(n * n3 / 100, n3);
                                        }
                                        catch (CancelException cancelException) {
                                            // empty catch block
                                        }
                                    }
                                }
                            });
                            outputStream = new BufferedOutputStream(new FileOutputStream(file));
                            JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
                            if (Environment.isJavaPlugin() && HttpDownloadHelper.getJarCompressionLevel() != 0) {
                                jarOutputStream.setLevel(HttpDownloadHelper.getJarCompressionLevel());
                            }
                            unpacker.unpack((InputStream)new GZIPInputStream(inputStream), jarOutputStream);
                            jarOutputStream.close();
                        } else if (DownloadEngine.isAlwaysCached(uRL.toString()) && !DownloadEngine.isZipFile(uRL.toString())) {
                            zipOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                            if (HttpDownloadHelper.getJarCompressionLevel() != 0) {
                                zipOutputStream.setLevel(HttpDownloadHelper.getJarCompressionLevel());
                            }
                            if (string != null && string.indexOf("gzip") >= 0) {
                                zipInputStream = new ZipInputStream(new GZIPInputStream((InputStream)new BufferedInputStream(inputStream), 8192));
                                this.decompressWrite(zipInputStream, zipOutputStream, n3, httpDownloadListener);
                            } else {
                                ZipEntry zipEntry;
                                zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream, 8192));
                                if (uRL.toString().toLowerCase().endsWith(JARJAR_FILE_EXT)) {
                                    zipEntry = zipInputStream.getNextEntry();
                                    while (zipEntry != null) {
                                        if (zipEntry.toString().toLowerCase().startsWith(META_FILE_DIR)) {
                                            zipEntry = zipInputStream.getNextEntry();
                                            continue;
                                        }
                                        if (zipEntry.toString().toLowerCase().endsWith(JAR_FILE_EXT)) break;
                                        throw new IOException("cache.jarjar.invalid_file");
                                    }
                                    zipInputStream2 = zipInputStream;
                                    zipInputStream = new ZipInputStream(zipInputStream);
                                }
                                this.decompressWrite(zipInputStream, zipOutputStream, n3, httpDownloadListener);
                                if (zipInputStream2 != null && (zipEntry = zipInputStream2.getNextEntry()) != null) {
                                    String string2 = null;
                                    if (!zipEntry.toString().toLowerCase().endsWith(JAR_FILE_EXT)) {
                                        string2 = "cache.jarjar.invalid_file";
                                        throw new IOException(string2);
                                    }
                                    string2 = "cache.jarjar.multiple_jar";
                                    throw new IOException(string2);
                                }
                            }
                        } else {
                            FilterInputStream filterInputStream = new BufferedInputStream(inputStream);
                            URL uRL2 = HttpUtils.removeQueryStringFromURL(uRL);
                            if (uRL2 != null && !uRL2.toString().toLowerCase().endsWith(".gz") && string != null && string.indexOf("gzip") >= 0) {
                                filterInputStream = new GZIPInputStream((InputStream)filterInputStream, 8192);
                            }
                            int n4 = 0;
                            int n5 = 0;
                            byte[] byArray = new byte[32768];
                            outputStream = new BufferedOutputStream(new FileOutputStream(file));
                            int n6 = 0;
                            while ((n4 = ((InputStream)filterInputStream).read(byArray, 0, byArray.length)) != -1) {
                                if (DownloadEngine.isJarContentType(n2) && n6 == 0 && !DownloadEngine.isJarHeaderValid(byArray)) {
                                    throw new IOException("Invalid jar file");
                                }
                                outputStream.write(byArray, 0, n4);
                                if ((n5 += n4) > n3 && n3 != 0) {
                                    n5 = n3;
                                }
                                if (httpDownloadListener != null) {
                                    httpDownloadListener.downloadProgress(n5, n3);
                                }
                                ++n6;
                            }
                        }
                        if (Trace.isEnabled(TraceLevel.NETWORK)) {
                            Trace.println(ResourceManager.getString("httpDownloadHelper.wroteUrlToFile", uRL == null ? "" : uRL.toString(), file == null ? "" : file.toString()), TraceLevel.NETWORK);
                        }
                    }
                    catch (IOException iOException) {
                        bl = true;
                        throw iOException;
                    }
                    Object var21_25 = null;
                    if (zipInputStream2 == null) break block39;
                }
                catch (Throwable throwable) {
                    Object var21_26 = null;
                    if (zipInputStream2 != null) {
                        zipInputStream2.close();
                    } else if (zipInputStream != null) {
                        zipInputStream.close();
                    } else if (inputStream != null) {
                        inputStream.close();
                    }
                    if (zipOutputStream != null) {
                        zipOutputStream.close();
                    } else {
                        outputStream.close();
                    }
                    if (!bl) throw throwable;
                    if (file == null) throw throwable;
                    file.delete();
                    throw throwable;
                }
                zipInputStream2.close();
                break block40;
            }
            if (zipInputStream != null) {
                zipInputStream.close();
            } else if (inputStream != null) {
                inputStream.close();
            }
        }
        if (zipOutputStream != null) {
            zipOutputStream.close();
        } else {
            outputStream.close();
        }
        if (bl && file != null) {
            file.delete();
        }
        if (httpDownloadListener == null) return;
        httpDownloadListener.downloadProgress(n3, n3);
    }

    private void decompressWrite(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream, int n, HttpDownloadListener httpDownloadListener) throws IOException {
        byte[] byArray = new byte[8192];
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        int n2 = 0;
        while (zipEntry != null) {
            ZipEntry zipEntry2 = (ZipEntry)zipEntry.clone();
            zipEntry2.setCompressedSize(-1L);
            zipOutputStream.putNextEntry(zipEntry2);
            int n3 = 0;
            while ((n3 = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                zipOutputStream.write(byArray, 0, n3);
                if ((n2 += n3) > n && n != 0) {
                    n2 = n;
                }
                if (httpDownloadListener == null) continue;
                httpDownloadListener.downloadProgress(n2, n);
            }
            zipOutputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipOutputStream.flush();
    }
}

