/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.RuleBasedCollator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.CollationElementsInterface;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;

final class WorkHorseForCollatorDatatypes {
    private RuleBasedCollator collatorForCharacterDatatypes;
    private SQLChar stringData;
    private int[] collationElementsForString;
    private int countOfCollationElements;
    private CollationKey cKey;

    WorkHorseForCollatorDatatypes(RuleBasedCollator ruleBasedCollator, SQLChar sQLChar) {
        this.collatorForCharacterDatatypes = ruleBasedCollator;
        this.stringData = sQLChar;
    }

    int stringCompare(SQLChar sQLChar, SQLChar sQLChar2) throws StandardException {
        CollationKey collationKey = sQLChar.getCollationKey();
        CollationKey collationKey2 = sQLChar2.getCollationKey();
        if (collationKey == null || collationKey2 == null) {
            if (collationKey != null) {
                return -1;
            }
            if (collationKey2 != null) {
                return 1;
            }
            return 0;
        }
        return collationKey.compareTo(collationKey2);
    }

    BooleanDataValue like(DataValueDescriptor dataValueDescriptor) throws StandardException {
        Boolean bl = Like.like(this.stringData.getCharArray(), this.stringData.getLength(), ((SQLChar)dataValueDescriptor).getCharArray(), dataValueDescriptor.getLength(), null, 0, this.collatorForCharacterDatatypes);
        return SQLBoolean.truthValue((DataValueDescriptor)this.stringData, dataValueDescriptor, bl);
    }

    BooleanDataValue like(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        if (dataValueDescriptor2.isNull()) {
            throw StandardException.newException("22501");
        }
        CollationElementsInterface collationElementsInterface = (CollationElementsInterface)((Object)dataValueDescriptor2);
        if (collationElementsInterface.getCollationElementsForString() != null && collationElementsInterface.getCountOfCollationElements() != 1) {
            throw StandardException.newException("22019", new String(collationElementsInterface.toString()));
        }
        Boolean bl = Like.like(this.stringData.getCharArray(), this.stringData.getLength(), ((SQLChar)dataValueDescriptor).getCharArray(), dataValueDescriptor.getLength(), ((SQLChar)dataValueDescriptor2).getCharArray(), dataValueDescriptor2.getLength(), this.collatorForCharacterDatatypes);
        return SQLBoolean.truthValue((DataValueDescriptor)this.stringData, dataValueDescriptor, bl);
    }

    RuleBasedCollator getCollatorForCollation() {
        return this.collatorForCharacterDatatypes;
    }

    int getCountOfCollationElements() {
        return this.countOfCollationElements;
    }

    int[] getCollationElementsForString() throws StandardException {
        int n;
        if (this.stringData.isNull()) {
            return null;
        }
        this.collationElementsForString = null;
        this.countOfCollationElements = 0;
        if (this.collationElementsForString != null) {
            return this.collationElementsForString;
        }
        this.collationElementsForString = new int[this.stringData.getLength()];
        CollationElementIterator collationElementIterator = this.collatorForCharacterDatatypes.getCollationElementIterator(this.stringData.getString());
        while ((n = collationElementIterator.next()) != -1) {
            if (this.countOfCollationElements == this.collationElementsForString.length) {
                int[] nArray = new int[this.countOfCollationElements + 5];
                System.arraycopy(this.collationElementsForString, 0, nArray, 0, this.collationElementsForString.length);
                this.collationElementsForString = nArray;
            }
            this.collationElementsForString[this.countOfCollationElements++] = n;
        }
        return this.collationElementsForString;
    }
}

