/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.spec;

import iaik.xml.crypto.dsig.spec.AlgorithmParameterImpl;
import iaik.xml.crypto.utils.DOMUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.spec.XPathType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XPath2ParameterImpl
extends AlgorithmParameterImpl {
    protected XPathType xPathType_;
    protected Map namespaceMap_;
    protected String xpath_;
    protected String filter_;

    protected void unmarshalElement(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.unmarshalElement(dOMCryptoContext, element);
        this.xpath_ = DOMUtils.getAllTextFromChildren(element);
    }

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        String string;
        super.unmarshalAttributes(namedNodeMap, dOMCryptoContext);
        Attr attr = (Attr)namedNodeMap.getNamedItemNS(null, "Filter");
        String string2 = string = attr != null ? attr.getValue() : null;
        if (string == null || !string.equals("intersect") && !string.equals("subtract") && !string.equals("union")) {
            throw new MarshalException("XPath 'Filter'-Attribute value must be one of: 'intersect', 'subtract', 'union'");
        }
        this.filter_ = string;
    }

    protected Element marshalElement(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Element element = super.marshalElement(dOMCryptoContext, node, node2);
        if (this.xpath_ != null) {
            DOMUtils.addTextToElement(element, this.xpath_);
        }
        return element;
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.marshalAttributes(dOMCryptoContext, element);
        Document document = DOMUtils.getOwnerDocument(element);
        Attr attr = document.createAttributeNS("", "Filter");
        attr.setValue(this.filter_);
        element.setAttributeNode(attr);
        if (!this.namespaceMap_.isEmpty()) {
            Set set = this.namespaceMap_.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Attr attr2 = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + (String)entry.getKey());
                attr2.setValue((String)entry.getValue());
                element.setAttributeNodeNS(attr2);
            }
        }
    }

    public String getXpath() {
        return this.xpath_;
    }

    public String getNamespace() {
        return "http://www.w3.org/2002/06/xmldsig-filter2";
    }

    public String getLocalName() {
        return "XPath";
    }

    public String getFilter() {
        return this.filter_;
    }

    public XPath2ParameterImpl(XPathType xPathType) {
        if (xPathType == null) {
            throw new NullPointerException("Argument 'xPathType' must not be null");
        }
        this.xPathType_ = xPathType;
        this.filter_ = xPathType.getFilter().equals(XPathType.Filter.INTERSECT) ? "intersect" : (xPathType.getFilter().equals(XPathType.Filter.SUBTRACT) ? "subtract" : "union");
        this.xpath_ = xPathType.getExpression();
        this.namespaceMap_ = xPathType.getNamespaceMap();
    }

    public XPath2ParameterImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.namespaceMap_ = new HashMap();
        this.unmarshal(dOMCryptoContext);
        if (this.filter_ == null || this.xpath_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }
}

