/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.event.AppInitEvent;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.Platform;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.DownloadException;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.pings.Pings;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.ComponentRef;
import com.sun.deploy.util.ArrayUtil;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.PerfLogger;
import com.sun.javaws.BrowserSupport;
import com.sun.javaws.Globals;
import com.sun.javaws.JAuthenticator;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JreExecException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.NoLocalJREException;
import com.sun.javaws.exceptions.OfflineLaunchException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.LaunchSelection;
import com.sun.javaws.progress.PreloaderDelegate;
import com.sun.javaws.progress.Progress;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.JNLPSignedResourcesHelper;
import com.sun.javaws.security.JavaWebStartSecurity;
import com.sun.javaws.ui.AutoDownloadPrompt;
import com.sun.javaws.ui.LaunchErrorDialog;
import com.sun.javaws.ui.SecureStaticVersioning;
import com.sun.javaws.ui.SplashScreen;
import com.sun.javaws.util.JavawsConsoleController;
import com.sun.javaws.util.JfxHelper;
import com.sun.jnlp.AppletContainer;
import com.sun.jnlp.AppletContainerCallback;
import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.JNLPClassLoader;
import com.sun.jnlp.PreverificationClassLoader;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import sun.awt.AppContext;

public class Launcher
implements Runnable {
    private LaunchDesc _initialLaunchDesc;
    private LaunchDesc _launchDesc;
    private String[] _args;
    private boolean _exit = true;
    private JAuthenticator _ja;
    private LocalApplicationProperties _lap = null;
    private JNLPClassLoader _jnlpClassLoader = null;
    private JREInfo _jreInfo = null;
    private boolean _isRelaunch = false;
    private boolean _isCached = false;
    private boolean _jreInstalled = false;
    private LaunchSelection.MatchJREIf _jreMatcher;
    boolean securityManagerDiabledForTests = false;
    private boolean _shownDownloadWindow = false;

    public Launcher(LaunchDesc launchDesc) {
        this._initialLaunchDesc = launchDesc;
        Trace.println((String)("new Launcher: " + launchDesc.toString()), (TraceLevel)TraceLevel.BASIC);
        PerfLogger.setTime((String)"End: Launcher constructor");
    }

    public void launch(String[] stringArray, boolean bl) {
        this._args = stringArray;
        this._exit = bl;
        if (this.prepareToLaunch()) {
            new Thread(Main.getLaunchThreadGroup(), this, "javawsApplicationMain").start();
        } else if (!Environment.isImportMode()) {
            LaunchErrorDialog.show(Progress.get(null).getOwner(), new Exception(ResourceManager.getString((String)"launch.error.category.unexpected")), true);
        }
    }

    public void run() {
        block8: {
            try {
                this.doLaunchApp();
            }
            catch (Throwable throwable) {
                int n;
                ExitException exitException = throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 3);
                int n2 = n = exitException.getReason() == 0 ? 0 : -1;
                if (exitException.getReason() == 3) {
                    if (this._launchDesc.getUpdater().isBackgroundUpdateRunning() && this._lap != null) {
                        this._lap.setForceUpdateCheck(true);
                        try {
                            this._lap.store();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    LaunchErrorDialog.show(Progress.get(null).getOwner(), exitException.getException(), this._exit);
                }
                if (!this._exit) break block8;
                try {
                    Main.systemExit(n);
                }
                catch (ExitException exitException2) {
                    Trace.println((String)("systemExit: " + exitException2), (TraceLevel)TraceLevel.BASIC);
                    Trace.ignoredException((Exception)exitException2);
                }
            }
        }
    }

    private boolean isImport() {
        return Environment.isImportMode() || this._launchDesc != null && this._launchDesc.isLibrary();
    }

    private boolean prepareToLaunch() {
        PerfLogger.setTime((String)"Start: prepareToLaunch()");
        if (SingleInstanceManager.isServerRunning((String)this._initialLaunchDesc.getCanonicalHome().toString())) {
            String[] stringArray = Globals.getApplicationArgs();
            if (stringArray != null && this._initialLaunchDesc.getApplicationDescriptor() != null) {
                this._initialLaunchDesc.getApplicationDescriptor().setArguments(stringArray);
            }
            if (SingleInstanceManager.connectToServer((String)this._initialLaunchDesc.toString())) {
                Trace.println((String)"Exiting (launched in the other instance)", (TraceLevel)TraceLevel.BASIC);
                return true;
            }
        }
        PerfLogger.setTime((String)"setting tryOffline");
        boolean bl = Cache.isCacheEnabled() && (this._initialLaunchDesc.getUpdate().isBackgroundCheck() || DeployOfflineManager.isForcedOffline() || JnlpxArgs.getIsRelaunch());
        PerfLogger.setTime((String)(" tryOffline = " + bl));
        try {
            if (!bl && DeployOfflineManager.isForcedOffline()) {
                throw new CacheUpdateRequiredException("Forced offline mode!");
            }
            boolean bl2 = this.prepareToLaunch(bl);
            if (Cache.isCacheEnabled() && !DeployOfflineManager.isForcedOffline()) {
                this._launchDesc.getUpdater().startBackgroundUpdateOpt();
            }
            PerfLogger.setTime((String)"End: prepareToLaunch()");
            return bl2;
        }
        catch (CacheUpdateRequiredException cacheUpdateRequiredException) {
            Trace.println((String)("Could not launch from cache. Will try online mode. [" + cacheUpdateRequiredException.getMessage() + "]"));
            if (bl && DeployOfflineManager.isForcedOffline()) {
                DeployOfflineManager.setForcedOffline((boolean)false);
                if (!DeployOfflineManager.askUserGoOnline((URL)this._initialLaunchDesc.getLocation())) {
                    DeployOfflineManager.setForcedOffline((boolean)true);
                    Trace.println((String)"User chose not to go online and we can not not start in offline mode");
                    LaunchErrorDialog.show(Progress.get(null).getOwner(), new OfflineLaunchException(0), this._exit);
                    return false;
                }
            }
            try {
                PerfLogger.setTime((String)"End: prepareToLaunch()");
                return this.prepareToLaunch(false);
            }
            catch (CacheUpdateRequiredException cacheUpdateRequiredException2) {
                Trace.println((String)("Unexpected exception: " + cacheUpdateRequiredException2));
                return false;
            }
        }
    }

    private boolean prepareToLaunch(boolean bl) throws CacheUpdateRequiredException {
        PerfLogger.setTime((String)"Start: prepareToLaunch1()");
        try {
            URL uRL;
            Trace.println((String)("prepareToLaunch: offlineOnly=" + bl), (TraceLevel)TraceLevel.NETWORK);
            PerfLogger.setTime((String)"Begin updateFinalLaunchDesc");
            boolean bl2 = this.updateFinalLaunchDesc(this._initialLaunchDesc, 0, bl);
            this.removeTempJnlpFile(this._launchDesc);
            if (bl2) {
                File file = null;
                if (this._launchDesc.isApplicationDescriptor()) {
                    try {
                        file = DownloadEngine.getCachedFile((URL)this._launchDesc.getCanonicalHome());
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                    }
                    if (this._args != null) {
                        this._args[0] = file.getPath();
                    }
                }
            }
            PerfLogger.setTime((String)"End updateFinalLaunchDesc");
            boolean bl3 = this._launchDesc.isInstaller();
            this._isRelaunch = JnlpxArgs.getIsRelaunch();
            URL uRL2 = this._launchDesc.getCanonicalHome();
            if (!bl3 && !this._launchDesc.isLibrary()) {
                this._lap = Cache.getLocalApplicationProperties((URL)uRL2);
                if (bl && this._lap != null && this._lap.forceUpdateCheck()) {
                    throw new CacheUpdateRequiredException("Need to update: force update set in LAP");
                }
            }
            if (bl2 && this._lap != null && Cache.isCacheEnabled() && this._lap.isShortcutInstalled() && LocalInstallHandler.getInstance().isShortcutExists(this._lap)) {
                Launcher.notifyLocalInstallHandler(this._launchDesc, this._lap, Globals.isSilentMode(), bl2, Progress.get(null).getOwnerRef());
            }
            if ((uRL = this._launchDesc.getLocation()) != null) {
                Cache.removeRemovedApp((String)uRL.toString(), (String)this._launchDesc.getInformation().getTitle());
            }
            Trace.println((String)("isUpdated: " + bl2), (TraceLevel)TraceLevel.NETWORK);
            if (this._launchDesc.getResources() != null) {
                Globals.getDebugOptionsFromProperties(this._launchDesc.getResources().getResourceProperties());
            }
            if (Config.getBooleanProperty((String)"deployment.security.authenticator")) {
                this._ja = JAuthenticator.getInstance(Progress.get(null).getOwnerRef());
                Authenticator.setDefault((Authenticator)((Object)this._ja));
            }
            this.prepareAllResources(this._launchDesc, this._args, bl2, bl);
        }
        catch (CacheUpdateRequiredException cacheUpdateRequiredException) {
            throw cacheUpdateRequiredException;
        }
        catch (Throwable throwable) {
            int n;
            ExitException exitException = throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 3);
            int n2 = n = exitException.getReason() == 0 ? 0 : -1;
            if (exitException.getReason() == 3) {
                LaunchErrorDialog.show(Progress.get(null).getOwner(), exitException.getException(), this._exit);
            } else if (exitException.getReason() == 6) {
                LaunchErrorDialog.show(Progress.get(null).getOwner(), exitException, this._exit);
            }
            if (n == 0) {
                Trace.println((String)"Exiting", (TraceLevel)TraceLevel.BASIC);
            } else {
                Trace.ignoredException((Exception)exitException);
            }
            if (this._exit) {
                try {
                    Main.systemExit(n);
                }
                catch (ExitException exitException2) {
                    Trace.println((String)("systemExit: " + exitException2), (TraceLevel)TraceLevel.BASIC);
                    Trace.ignoredException((Exception)exitException2);
                }
            }
            PerfLogger.setTime((String)"End: prepareToLaunch1()");
            return false;
        }
        PerfLogger.setTime((String)"End: prepareToLaunch1()");
        return true;
    }

    private boolean updateFinalLaunchDesc(LaunchDesc launchDesc, int n, boolean bl) throws ExitException, CacheUpdateRequiredException {
        try {
            URL uRL = launchDesc.getLocation();
            if (uRL == null) {
                this._launchDesc = launchDesc;
                return LaunchDownload.updateLaunchDescInCache(launchDesc) != launchDesc;
            }
            URL uRL2 = this.deriveCodebase(uRL);
            String string = Config.getCacheDirectory();
            String string2 = Config.getSystemCacheDirectory();
            boolean bl2 = this._args[0] != null && (string != null && this._args[0].startsWith(string) || string2 != null && this._args[0].startsWith(string2));
            File file = DownloadEngine.getCachedFile((URL)uRL);
            if (!bl && bl2) {
                LaunchDesc launchDesc2 = LaunchDownload.getUpdatedLaunchDesc(uRL, null);
                if (launchDesc2 == null) {
                    this._launchDesc = launchDesc;
                    return false;
                }
                URL uRL3 = launchDesc2.getLocation();
                if (uRL3 == null || !uRL3.toString().equals(uRL.toString()) && n == 0) {
                    Cache.removeCacheEntry((URL)uRL, null, null);
                    return this.updateFinalLaunchDesc(launchDesc2, ++n, false);
                }
                this._launchDesc = launchDesc2;
                return true;
            }
            if (file != null) {
                block20: {
                    try {
                        this._launchDesc = LaunchDescFactory.buildDescriptor(file, uRL2, null, uRL);
                    }
                    catch (LaunchDescException launchDescException) {
                        this._launchDesc = LaunchDescFactory.buildDescriptor(file);
                        if (this._launchDesc != null) break block20;
                        throw launchDescException;
                    }
                }
                LaunchDesc launchDesc3 = null;
                if (!launchDesc.hasIdenticalContent(this._launchDesc)) {
                    if (n == 0 && bl) {
                        throw new CacheUpdateRequiredException("Given JNLP is newer than cached copy!");
                    }
                    launchDesc3 = LaunchDownload.getUpdatedLaunchDesc(uRL, null);
                }
                if (launchDesc3 != null) {
                    this._launchDesc = launchDesc3;
                    URL uRL4 = this._launchDesc.getLocation();
                    if (uRL4 == null || !uRL4.toString().equals(uRL.toString()) && n == 0) {
                        Cache.removeCacheEntry((URL)uRL, null, null);
                        return this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
                    }
                    return true;
                }
                Cache.removeRemovedApp((String)uRL.toString(), (String)this._launchDesc.getInformation().getTitle());
                URL uRL5 = this._launchDesc.getLocation();
                if (uRL5 == null || !uRL5.toString().equals(uRL.toString()) && n == 0) {
                    Cache.removeCacheEntry((URL)uRL, null, null);
                    return this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
                }
                this._launchDesc = launchDesc;
                return false;
            }
            if (bl) {
                throw new CacheUpdateRequiredException("Missing from the cache: " + uRL);
            }
            if (Cache.isCacheEnabled()) {
                DownloadEngine.getResource((URL)uRL, null, null, null, (boolean)true);
                file = DownloadEngine.getCachedFile((URL)uRL);
                if (file != null) {
                    this._launchDesc = LaunchDescFactory.buildDescriptor(file, uRL2, null, uRL);
                    URL uRL6 = this._launchDesc.getLocation();
                    if (uRL6 == null || !uRL6.toString().equals(uRL.toString()) && n == 0) {
                        Cache.removeCacheEntry((URL)uRL, null, null);
                        return this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
                    }
                    return true;
                }
                throw new Exception("cache failed for" + uRL);
            }
            this._launchDesc = LaunchDescFactory.buildDescriptor(uRL, uRL2);
            URL uRL7 = this._launchDesc.getLocation();
            if (uRL7 != null && !uRL7.toString().equals(uRL.toString()) && n == 0) {
                return this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
            }
            return false;
        }
        catch (CacheUpdateRequiredException cacheUpdateRequiredException) {
            throw cacheUpdateRequiredException;
        }
        catch (Exception exception) {
            throw new ExitException(exception, 3);
        }
    }

    private URL deriveCodebase(URL uRL) {
        try {
            return new URL(uRL.toString().substring(0, uRL.toString().lastIndexOf("/") + 1));
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException((Exception)malformedURLException);
            return null;
        }
    }

    private void removeTempJnlpFile(LaunchDesc launchDesc) {
        File file = null;
        if (launchDesc.isApplicationDescriptor()) {
            try {
                file = DownloadEngine.getCachedFile((URL)launchDesc.getCanonicalHome());
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        if (file == null) {
            return;
        }
        if (this._args != null && file != null && JnlpxArgs.shouldRemoveArgumentFile()) {
            new File(this._args[0]).delete();
            JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
            this._args[0] = file.getPath();
        }
    }

    static String getCurrentJavaFXVersion() {
        URL uRL = null;
        try {
            uRL = new URL("http://dl.javafx.com/javafx-rt.jnlp");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        CacheEntry cacheEntry = Cache.getLatestCacheEntry((URL)uRL, null);
        LaunchDesc launchDesc = null;
        String string = "XX";
        if (cacheEntry != null) {
            try {
                launchDesc = LaunchDescFactory.buildDescriptor(cacheEntry.getDataFile(), null, null, uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = launchDesc.getVersion();
        }
        return string;
    }

    static String getRequestedJavaFXVersion(LaunchDesc launchDesc) {
        String string = "XX";
        if (launchDesc != null) {
            string = launchDesc.getVersion();
        }
        return string;
    }

    void prepareAllResources(LaunchDesc launchDesc, String[] stringArray, boolean bl, boolean bl2) throws ExitException, CacheUpdateRequiredException {
        PerfLogger.setTime((String)"Start: prepareAllResources()");
        ArrayList arrayList = new ArrayList();
        boolean bl3 = this.prepareLaunchFile(launchDesc, stringArray, bl2, arrayList);
        this.prepareSecurity(launchDesc);
        if (!bl2) {
            this.prepareEnvironment(launchDesc);
            if (!Globals.isSilentMode() && !bl2) {
                this.prepareCustomProgress(launchDesc);
            }
        } else {
            AppPolicy.createInstance(launchDesc.getCanonicalHome().getHost());
        }
        this.prepareResources(launchDesc, stringArray, bl, bl2, bl3, arrayList);
        if (bl2) {
            this.prepareEnvironment(launchDesc);
            PreloaderDelegate preloaderDelegate = Progress.get(null);
            preloaderDelegate.setPreloaderClass(launchDesc.getProgressClassName());
            preloaderDelegate.initPreloader(this._jnlpClassLoader, Main.getLaunchThreadGroup());
        }
        PerfLogger.setTime((String)"End: prepareAllResources()");
    }

    private boolean prepareLaunchFile(LaunchDesc launchDesc, String[] stringArray, boolean bl, ArrayList arrayList) throws ExitException, CacheUpdateRequiredException {
        boolean bl2;
        Serializable serializable;
        Object object;
        boolean bl3 = false;
        if (launchDesc.getResources() == null) {
            this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.noappresources", (String)launchDesc.getSpecVersion()), null));
        }
        if (!this.isImport() && launchDesc.isLibrary()) {
            LaunchDescException launchDescException = new LaunchDescException(launchDesc, "Internal Error: !isImport() && ld.isLibrary()", null);
            this.handleJnlpFileException(launchDesc, launchDescException);
        }
        boolean bl4 = launchDesc.isInstaller();
        JNLPException.setDefaultLaunchDesc(launchDesc);
        JREInfo jREInfo = JREInfo.getHomeJRE();
        Trace.println((String)("Launcher: isInstaller: " + bl4 + ", isRelaunch: " + this._isRelaunch + ", isImport(): " + this.isImport() + ", java.home:" + Environment.getJavaHome() + ", Running JRE: " + jREInfo), (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)"JREInfos", (TraceLevel)TraceLevel.BASIC);
        JREInfo.traceJREs();
        if (jREInfo == null) {
            object = new LaunchDescException(launchDesc, "Internal Error: no running JRE", null);
            this.handleJnlpFileException(launchDesc, (Exception)object);
        }
        if (!launchDesc.getInformation().supportsOfflineOperation() && DeployOfflineManager.isGlobalOffline()) {
            throw new ExitException(new OfflineLaunchException(1), 3);
        }
        PerfLogger.setTime((String)"  - Start: LaunchDownload.isInCache(ld)");
        if (launchDesc.getUpdate().isBackgroundCheck() && (this._lap == null || !this._lap.forceUpdateCheck())) {
            this._isCached = LaunchDownload.isInCache(launchDesc);
        }
        PerfLogger.setTime((String)"  - End: LaunchDownload.isInCache(ld)");
        if (!this._isCached && !bl) {
            try {
                LaunchDownload.downloadExtensions(launchDesc, null, 0, arrayList);
                bl3 = true;
            }
            catch (Exception exception) {
                if (!launchDesc.getInformation().supportsOfflineOperation() || !LaunchDownload.isInCache(launchDesc)) {
                    throw new ExitException(exception, 3);
                }
                Trace.ignoredException((Exception)exception);
            }
        } else {
            bl3 = this._isCached;
        }
        if (!bl3) {
            if (!launchDesc.getInformation().supportsOfflineOperation() || !LaunchDownload.isInCache(launchDesc)) {
                throw new CacheUpdateRequiredException("Some of required resources are not cached.");
            }
            bl3 = true;
        }
        object = launchDesc.getJREMatcher();
        JVMParameters jVMParameters = object.getSelectedJVMParameters();
        this._jreInfo = object.getSelectedJREInfo();
        JREDesc jREDesc = object.getSelectedJREDesc();
        if (this._jreInfo == null && jREDesc == null || null == jVMParameters) {
            Trace.println((String)object.toString());
            serializable = new LaunchDescException(launchDesc, "Internal Error: Internal error, jreMatcher uninitialized", null);
            this.handleJnlpFileException(launchDesc, (Exception)serializable);
        }
        if (!launchDesc.isJRESpecified()) {
            serializable = new LaunchDescException(launchDesc, "Internal Error: !isJRESpecified()", null);
            this.handleJnlpFileException(launchDesc, (Exception)serializable);
        }
        if (launchDesc.needFX()) {
            try {
                if (this._jreInfo != null) {
                    JfxHelper.validateJfxRequest(launchDesc, this._jreInfo);
                } else {
                    JfxHelper.validateJfxRequest(launchDesc, jREDesc);
                }
            }
            catch (LaunchDescException launchDescException) {
                throw new ExitException(launchDescException, 3);
            }
        }
        if ((serializable = launchDesc.getCanonicalHome()) == null) {
            LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainjar"), null);
            throw new ExitException(launchDescException, 3);
        }
        if (bl4) {
            this._lap = Cache.getLocalApplicationProperties((String)stringArray[0]);
            if (this._lap == null || !Environment.isInstallMode()) {
                this.handleJnlpFileException(launchDesc, new MissingFieldException(launchDesc.getSource(), "<application-desc>|<applet-desc>"));
            }
            serializable = this._lap.getLocation();
        } else if (!launchDesc.isLibrary()) {
            this._lap = Cache.getLocalApplicationProperties((URL)serializable);
        }
        Trace.println((String)("LaunchDesc location: " + serializable), (TraceLevel)TraceLevel.BASIC);
        boolean bl5 = bl2 = this._isCached && DeployOfflineManager.isGlobalOffline();
        if (!this.isImport() && this._jreInfo == null) {
            String string;
            boolean bl6;
            if (bl) {
                throw new CacheUpdateRequiredException("Need to install JRE");
            }
            String string2 = Config.getStringProperty((String)"deployment.javaws.autodownload");
            if (string2 != null && string2.equalsIgnoreCase("NEVER")) {
                throw new ExitException(new NoLocalJREException(launchDesc, jREDesc.getVersion(), false), 3);
            }
            String string3 = jREDesc.getSource();
            URL uRL = jREDesc.getHref();
            boolean bl7 = bl6 = uRL == null;
            if (bl6) {
                string = Config.getStringProperty((String)"deployment.javaws.installURL");
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new ExitException(malformedURLException, 3);
                }
            }
            if ((string = DownloadEngine.getAvailableVersion((URL)uRL, (String)jREDesc.getVersion(), (boolean)bl6, (String)JREInfo.getKnownPlatforms())) == null) {
                string = jREDesc.getVersion();
            }
            if (SecureStaticVersioning.promptRequired(launchDesc, this._lap, true, string) ? !SecureStaticVersioning.promptDownload(null, launchDesc, this._lap, string, string3) : string2 != null && string2.equalsIgnoreCase("PROMPT") && !AutoDownloadPrompt.prompt(null, launchDesc)) {
                throw new ExitException(null, 0);
            }
        } else if (!this.isImport() && SecureStaticVersioning.promptRequired(launchDesc, this._lap, false, this._jreInfo.getProduct()) && !SecureStaticVersioning.promptUse(null, launchDesc, this._lap, this._jreInfo)) {
            throw new ExitException(null, 0);
        }
        return bl3;
    }

    private void prepareEnvironment(LaunchDesc launchDesc) throws ExitException {
        if (this.isImport() && !launchDesc.isInstaller()) {
            return;
        }
        AppPolicy appPolicy = AppPolicy.createInstance(launchDesc.getCanonicalHome().getHost());
        this._jnlpClassLoader = JNLPClassLoader.createClassLoader(launchDesc, appPolicy);
        try {
            String string = "http";
            URL uRL = launchDesc.getCanonicalHome();
            if (uRL.getProtocol().equalsIgnoreCase("file") && uRL.getHost().equals("")) {
                string = "file";
            }
            BasicServiceImpl.initialize(launchDesc.getCodebase(), BrowserSupport.isWebBrowserSupported(), string);
            if (launchDesc.getLaunchType() == 4) {
                String string2 = this._lap.getInstallDirectory();
                if (string2 == null) {
                    string2 = Cache.getNewExtensionInstallDirectory();
                    this._lap.setInstallDirectory(string2);
                }
                ExtensionInstallerServiceImpl.initialize(launchDesc.isSecure() ? null : string2, this._lap, Progress.get(null));
            }
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 3);
        }
        if (!this.securityManagerDiabledForTests) {
            System.setSecurityManager(new JavaWebStartSecurity());
        }
    }

    void disableSecurityManagerForTests() {
        this.securityManagerDiabledForTests = true;
    }

    private boolean isJfxSupportSatisfied(LaunchDesc launchDesc) {
        if (!launchDesc.needFX()) {
            return true;
        }
        if (launchDesc.isFXApp() && !ToolkitStore.isUsingPreferredToolkit((int)11, (int)0)) {
            return false;
        }
        return JfxHelper.isJfxSupportSatisfied(null, launchDesc);
    }

    private void relaunch(JREDesc jREDesc, String[] stringArray, JVMParameters jVMParameters, boolean bl, JfxRuntime jfxRuntime, boolean bl2) throws ExitException {
        if (this._isRelaunch) {
            Trace.println((String)"JAVAWS: Relaunch ignored: relaunched already", (TraceLevel)TraceLevel.BASIC);
            return;
        }
        long l = jREDesc.getMinHeap();
        long l2 = jREDesc.getMaxHeap();
        try {
            stringArray = this.insertApplicationArgs(stringArray);
            JnlpxArgs.execProgram(this._jreInfo, stringArray, l, l2, jVMParameters, bl, jfxRuntime, bl2);
        }
        catch (IOException iOException) {
            throw new ExitException(new JreExecException(this._jreInfo.getPath(), iOException), 3);
        }
        if (JnlpxArgs.shouldRemoveArgumentFile()) {
            JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
        }
        throw new ExitException(null, 0);
    }

    private void prepareResources(LaunchDesc launchDesc, String[] stringArray, boolean bl, boolean bl2, boolean bl3, ArrayList arrayList) throws ExitException, CacheUpdateRequiredException {
        boolean bl4;
        boolean bl5;
        boolean bl6;
        Object object;
        boolean bl7;
        PerfLogger.setTime((String)"  - Start: prepareResources");
        boolean bl8 = launchDesc.isInstaller();
        boolean bl9 = this._isCached && DeployOfflineManager.isGlobalOffline();
        JNLPSignedResourcesHelper jNLPSignedResourcesHelper = null;
        boolean bl10 = !this.isImport() && this._jreInfo == null || bl8;
        boolean bl11 = bl7 = !this._isCached || bl10;
        if (bl7 && bl9) {
            throw new ExitException(new OfflineLaunchException(0), 3);
        }
        boolean bl12 = bl7;
        if (!bl9) {
            if (this._lap != null && this._lap.forceUpdateCheck()) {
                Trace.println((String)"Forced update check in LAP, do full update", (TraceLevel)TraceLevel.BASIC);
                bl12 = true;
            } else if (!bl2 && !launchDesc.getUpdate().isBackgroundCheck() && launchDesc.getUpdate().getPolicy() == 0) {
                bl12 = true;
            } else if (!bl2) {
                try {
                    bl12 = launchDesc.getUpdater().isUpdateAvailable();
                }
                catch (Exception exception) {
                    throw new ExitException(exception, 3);
                }
                if (bl12 && launchDesc.getUpdate().getPolicy() != 0) {
                    this._isCached = LaunchDownload.isInCache(launchDesc);
                    if (this._isCached) {
                        bl7 = bl10;
                    }
                }
                if (launchDesc.getUpdater().isCheckAborted()) {
                    throw new ExitException(new LaunchDescException(launchDesc, "User rejected cert - aborted", null), 4);
                }
            }
        }
        Trace.println((String)("Offline mode: " + bl9 + "\nIsInCache: " + this._isCached + "\nforceUpdate: " + bl7 + "\nneedUpdate: " + bl12 + "\nIsInstaller: " + bl8), (TraceLevel)TraceLevel.BASIC);
        if (bl12 && !bl7) {
            bl7 = launchDesc.getUpdater().needUpdatePerPolicy(Progress.get(null));
        }
        if (bl7 && bl9) {
            throw new ExitException(new OfflineLaunchException(0), 3);
        }
        if (bl7) {
            PerfLogger.setTime((String)"    - Start: Update Check");
            if (!this.isImport() && this._jreInfo == null) {
                this.downloadJREResource(launchDesc, arrayList);
                if (!arrayList.isEmpty()) {
                    JnlpxArgs.executeInstallers(arrayList, Progress.get(null));
                    if (!launchDesc.isValidSpecificationVersion()) {
                        Platform.get().resetJavaHome();
                    }
                }
                object = Environment.getJavaHome() + File.separator + "bin" + File.separator;
                Platform.get().notifyJREInstalled((String)object);
                this._jreInstalled = true;
            } else {
                jNLPSignedResourcesHelper = new JNLPSignedResourcesHelper(launchDesc);
                jNLPSignedResourcesHelper.warmup();
                try {
                    this.downloadResources(launchDesc, arrayList, bl3, bl8);
                }
                catch (ExitException exitException) {
                    if (Environment.isJavaFXInstallInitiated()) {
                        Throwable throwable = exitException.getException();
                        if (throwable instanceof FailedDownloadException) {
                            String string = ((FailedDownloadException)throwable).getLocation().toString();
                            Pings.sendJFXPing((String)"jfxic", (String)Launcher.getCurrentJavaFXVersion(), (String)Launcher.getRequestedJavaFXVersion(launchDesc), (int)3, (String)string);
                        } else {
                            Pings.sendJFXPing((String)"jfxic", (String)Launcher.getCurrentJavaFXVersion(), (String)Launcher.getRequestedJavaFXVersion(launchDesc), (int)2, null);
                        }
                    }
                    throw exitException;
                }
            }
            if (this._lap != null && this._lap.forceUpdateCheck()) {
                this._lap.setForceUpdateCheck(false);
                try {
                    this._lap.store();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
            PerfLogger.setTime((String)"    - End: Update Check");
        }
        object = Progress.get(null);
        try {
            ((PreloaderDelegate)object).handleEvent((PreloaderEvent)new DownloadEvent(1, launchDesc.getLocation(), null, null, 1L, 1L, 100));
        }
        catch (CancelException cancelException) {
            throw new ExitException(cancelException, 3);
        }
        try {
            ((PreloaderDelegate)object).waitTillLoaded();
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (IOException iOException) {
            if (launchDesc.getInformation().supportsOfflineOperation() && LaunchDownload.isInCache(launchDesc, bl3)) {
                Trace.ignoredException((Exception)iOException);
            }
            throw new ExitException(iOException, 3);
        }
        if (this._jreInfo != null || this.isImport()) {
            SplashScreen.generateCustomSplash(launchDesc, bl);
            if (!this.isImport() && !arrayList.isEmpty()) {
                if (bl8) {
                    // empty if block
                }
                JnlpxArgs.executeInstallers(arrayList, Progress.get(null));
            }
            if (!Globals.isSilentMode() && launchDesc.isInstaller()) {
                try {
                    Progress.get(null).handleEvent((PreloaderEvent)new ConfigEvent(3, launchDesc.getAppInfo()));
                    Progress.get(null).handleEvent((PreloaderEvent)new InitEvent(2));
                }
                catch (CancelException cancelException) {
                    throw new ExitException(cancelException, 3);
                }
            }
        }
        LaunchSelection.MatchJREIf matchJREIf = launchDesc.getJREMatcher();
        JVMParameters jVMParameters = matchJREIf.getSelectedJVMParameters();
        this._jreInfo = matchJREIf.getSelectedJREInfo();
        JREDesc jREDesc = matchJREIf.getSelectedJREDesc();
        JfxRuntime jfxRuntime = null;
        if (launchDesc.needFX() && !Platform.get().isJavaFXEnabled()) {
            throw new ExitException(new Exception(ResourceManager.getString((String)"launch.error.jfx.disable")), 6);
        }
        boolean bl13 = bl6 = !this.isJfxSupportSatisfied(launchDesc);
        if (bl6 && null == (jfxRuntime = JfxHelper.getBestJfxInstalled(launchDesc))) {
            if (bl9) {
                throw new ExitException(new OfflineLaunchException(0), 3);
            }
            try {
                jfxRuntime = JfxHelper.installJfxRuntime(launchDesc, Progress.get(null));
            }
            catch (DownloadException downloadException) {
                throw new ExitException(ResourceManager.getMessage((String)"launch.error.jfx.download"), downloadException);
            }
            catch (Throwable throwable) {
                throw new ExitException(throwable, 3);
            }
        }
        if (!this.isImport()) {
            if (!launchDesc.isValidSpecificationVersion()) {
                JNLPException.setDefaultLaunchDesc(launchDesc);
                this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.badjnlversion", (String)launchDesc.getSpecVersion()), null));
            }
            if (this._jreInfo == null) {
                Config.get().refreshIfNeeded();
                this._jreInfo = launchDesc.selectJRE();
                if (this._jreInfo == null) {
                    Trace.println((String)("No JREInfo(1): " + launchDesc.getJREMatcher()));
                    LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException(launchDescException, 3);
                }
                matchJREIf = launchDesc.getJREMatcher();
                jREDesc = matchJREIf.getSelectedJREDesc();
                jVMParameters = matchJREIf.getSelectedJVMParameters();
            }
            bl5 = matchJREIf.isRunningJVMSatisfying(true);
            if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
                Trace.println((String)("_jreInstalled:    " + this._jreInstalled), (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)matchJREIf.toString(), (TraceLevel)TraceLevel.BASIC);
            }
            if (this._jreInstalled && bl5) {
                throw new ExitException(new Exception("Internal Error: jreInstalled, but homeJVM matches"), 3);
            }
            if (launchDesc.isSecureJVMArgs() && (!bl5 && this._jreInfo != null || bl6)) {
                this.relaunch(jREDesc, stringArray, jVMParameters, false, jfxRuntime, launchDesc.isFXApp());
            }
        }
        if (this.isImport()) {
            try {
                Progress.get(null).handleEvent((PreloaderEvent)new InitEvent(5));
            }
            catch (CancelException cancelException) {
                throw new ExitException(cancelException, 3);
            }
            bl5 = LaunchDownload.isJnlpCached(launchDesc) && bl;
            Launcher.notifyLocalInstallHandler(launchDesc, this._lap, Globals.isSilentMode(), bl5, null);
            if (Environment.isJavaFXInstallInitiated()) {
                Pings.sendJFXPing((String)"jfxic", (String)Launcher.getCurrentJavaFXVersion(), (String)Launcher.getRequestedJavaFXVersion(launchDesc), (int)0, null);
            }
            if (jNLPSignedResourcesHelper == null) {
                jNLPSignedResourcesHelper = new JNLPSignedResourcesHelper(launchDesc);
            }
            this.preverifyImportedJARs(jNLPSignedResourcesHelper, launchDesc);
            Trace.println((String)"Exiting after import", (TraceLevel)TraceLevel.BASIC);
            throw new ExitException(null, 0);
        }
        String string = " - " + launchDesc.getInformation().getTitle();
        JavawsConsoleController.getInstance().setTitle("console.caption", string);
        JavawsConsoleController.getInstance().showConsoleIfEnabled();
        boolean bl14 = false;
        try {
            PerfLogger.setTime((String)"    - Start: checkSignedLaunchDesc");
            if (jNLPSignedResourcesHelper == null) {
                jNLPSignedResourcesHelper = new JNLPSignedResourcesHelper(launchDesc);
            }
            jNLPSignedResourcesHelper.checkSignedLaunchDesc();
            PerfLogger.setTime((String)"    - End: checkSignedLaunchDesc");
            PerfLogger.setTime((String)"    - Start: checkSignedResources");
            bl14 = jNLPSignedResourcesHelper.checkSignedResources(Progress.get(null));
            PerfLogger.setTime((String)"    - End: checkSignedResources");
            bl14 = bl14 && launchDesc.isSigned();
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 3);
        }
        if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
            Trace.println((String)("passing security checks; secureArgs:" + launchDesc.isSecureJVMArgs() + ", allSigned:" + bl14), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("trusted app: " + !launchDesc.isSecure() + ", -secure=" + Globals.isSecureMode()), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)matchJREIf.toString(), (TraceLevel)TraceLevel.BASIC);
        }
        if (!(bl4 = matchJREIf.isRunningJVMSatisfying(bl14)) || bl6) {
            this.relaunch(jREDesc, stringArray, jVMParameters, bl14, jfxRuntime, launchDesc.isFXApp());
        }
        JnlpxArgs.removeArgumentFile(stringArray[0]);
        if (Cache.isCacheEnabled() && (!LocalInstallHandler.getInstance().isShortcutExists(this._lap) || Globals.isIconImageUpdated())) {
            Launcher.notifyLocalInstallHandler(launchDesc, this._lap, Globals.isSilentMode(), bl || Globals.isIconImageUpdated(), Progress.get(null).getOwnerRef());
            if (Globals.isIconImageUpdated()) {
                Globals.setIconImageUpdated(false);
            }
        }
        PerfLogger.setTime((String)"  - End prepareResources()");
        Trace.println((String)"continuing launch in this VM", (TraceLevel)TraceLevel.BASIC);
    }

    private void prepareCustomProgress(final LaunchDesc launchDesc) throws ExitException {
        final PreloaderDelegate preloaderDelegate = Progress.get(null);
        preloaderDelegate.setPreloaderClass(launchDesc.getProgressClassName());
        preloaderDelegate.markLoadingStarted();
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    LaunchDownload.downloadProgressJars(launchDesc, Progress.get(null));
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
                finally {
                    preloaderDelegate.initPreloader(Launcher.this._jnlpClassLoader, Main.getLaunchThreadGroup());
                    SplashScreen.hide();
                }
            }
        });
        thread.start();
    }

    private void preverifyImportedJARs(JNLPSignedResourcesHelper jNLPSignedResourcesHelper, LaunchDesc launchDesc) {
        if (Environment.getJavaFxInstallMode() == 1 || Environment.getJavaFxInstallMode() == 2) {
            try {
                jNLPSignedResourcesHelper.checkSignedResources(Progress.get(null));
            }
            catch (JNLPException jNLPException) {
                Trace.ignoredException((Exception)jNLPException);
            }
            catch (ExitException exitException) {
                Trace.ignoredException((Exception)exitException);
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
            PreverificationClassLoader preverificationClassLoader = new PreverificationClassLoader(ClassLoader.getSystemClassLoader());
            preverificationClassLoader.initialize(launchDesc);
            preverificationClassLoader.preverifyJARs();
        }
    }

    private String[] insertApplicationArgs(String[] stringArray) {
        String[] stringArray2 = Globals.getApplicationArgs();
        if (stringArray2 == null) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray2.length + stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3[i] = stringArray2[i];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray3[i++] = stringArray[i];
        }
        return stringArray3;
    }

    private void doLaunchApp() throws ExitException {
        JNLPClassLoader jNLPClassLoader = this._jnlpClassLoader;
        Thread.currentThread().setContextClassLoader(jNLPClassLoader);
        ToolkitStore.get().setContextClassLoader((ClassLoader)jNLPClassLoader);
        String string = this._launchDesc.getInformation().getTitle();
        AppContext.getAppContext().put("deploy.trust.decider.app.name", string);
        String string2 = null;
        Class<?> clazz = null;
        try {
            string2 = LaunchDownload.getMainClassName(this._launchDesc, true);
            Trace.println((String)("Main-class: " + string2), (TraceLevel)TraceLevel.BASIC);
            if (string2 == null) {
                throw new ClassNotFoundException(string2);
            }
            Progress.get(null).handleEvent((PreloaderEvent)new AppInitEvent(1));
            clazz = jNLPClassLoader.loadClass(string2);
            if (this.getClass().getPackage().equals(clazz.getPackage())) {
                throw new ClassNotFoundException(string2);
            }
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader != jNLPClassLoader && classLoader != jNLPClassLoader.getParent() && classLoader != jNLPClassLoader.getJNLPPreverifyClassLoader()) {
                SecurityException securityException = new SecurityException("Bad main-class name");
                throw new ExitException(securityException, 3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExitException(classNotFoundException, 3);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (Exception exception) {
            throw new ExitException(exception, 3);
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 3);
        }
        try {
            if (Globals.TCKHarnessRun) {
                Main.tckprintln("JNLP Launching");
            }
            PerfLogger.setTime((String)"calling executeMainClass ...");
            this.executeMainClass(this._launchDesc, this._lap, clazz, Progress.get(null));
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 3);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exception exception = invocationTargetException;
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Exception) {
                exception = (Exception)invocationTargetException.getTargetException();
            } else {
                throwable.printStackTrace();
            }
            throw new ExitException(exception, 3);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ExitException(noSuchMethodException, 3);
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 3);
        }
        if (this._launchDesc.getLaunchType() == 4) {
            throw new ExitException(null, 0);
        }
    }

    private void downloadJREResource(LaunchDesc launchDesc, ArrayList arrayList) throws ExitException {
        if (!this._shownDownloadWindow && !Globals.isSilentMode()) {
            this._shownDownloadWindow = true;
            try {
                Progress.get(null).handleEvent((PreloaderEvent)new ConfigEvent(3, launchDesc.getAppInfo()));
                Progress.get(null).handleEvent((PreloaderEvent)new InitEvent(0));
            }
            catch (CancelException cancelException) {
                throw new ExitException(cancelException, 3);
            }
        }
        try {
            if (!Cache.isCacheEnabled()) {
                throw new IOException("Cache disabled, cannot download JRE");
            }
            LaunchDownload.downloadJRE(launchDesc, Progress.get(null), arrayList);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
            throw new ExitException(new NoLocalJREException(launchDesc, launchDesc.getResources().getSelectedJRE().getVersion(), false), 3);
        }
    }

    private void downloadResources(LaunchDesc launchDesc, ArrayList arrayList, boolean bl, boolean bl2) throws ExitException {
        try {
            if (!this._shownDownloadWindow && !Globals.isSilentMode()) {
                this._shownDownloadWindow = true;
                PreloaderDelegate preloaderDelegate = Progress.get(null);
                preloaderDelegate.handleEvent((PreloaderEvent)new ConfigEvent(3, launchDesc.getAppInfo()));
                if (!bl2) {
                    preloaderDelegate.handleEvent((PreloaderEvent)new InitEvent(4));
                }
            }
            if (!bl) {
                LaunchDownload.downloadExtensions(launchDesc, Progress.get(null), 0, arrayList);
            }
            LaunchDownload.checkJNLPSecurity(launchDesc);
            LaunchDownload.downloadEagerorAll(launchDesc, false, Progress.get(null), false);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (Exception exception) {
            if (launchDesc.getInformation().supportsOfflineOperation() && LaunchDownload.isInCache(launchDesc, bl)) {
                Trace.ignoredException((Exception)exception);
            }
            throw new ExitException(exception, 3);
        }
    }

    public void prepareSecurity(LaunchDesc launchDesc) throws ExitException {
        try {
            LaunchDownload.checkJNLPSecurity(launchDesc);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
    }

    public static void notifyLocalInstallHandler(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl, boolean bl2, ComponentRef componentRef) {
        LocalInstallHandler localInstallHandler;
        if (localApplicationProperties == null) {
            return;
        }
        URL uRL = LaunchDescFactory.getDerivedCodebase();
        if (uRL != null) {
            localApplicationProperties.setCodebase(uRL.toString());
        }
        localApplicationProperties.setLastAccessed(new Date());
        if (!Environment.isImportMode() && !launchDesc.isLibrary()) {
            localApplicationProperties.incrementLaunchCount();
        }
        if ((localInstallHandler = LocalInstallHandler.getInstance()) != null) {
            localInstallHandler.install(launchDesc, localApplicationProperties, bl2, bl, componentRef);
        }
        try {
            localApplicationProperties.store();
        }
        catch (IOException iOException) {
            Trace.println((String)("Couldn't save LAP: " + iOException), (TraceLevel)TraceLevel.BASIC);
        }
    }

    private void executeMainClass(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Class clazz, PreloaderDelegate preloaderDelegate) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (launchDesc.getLaunchType() == 2) {
            boolean bl;
            String string = null;
            String string2 = null;
            boolean bl2 = false;
            if (localApplicationProperties != null) {
                string = localApplicationProperties.getCodebase();
                string2 = localApplicationProperties.getDocumentBase();
                bl2 = localApplicationProperties.isDraggedApplet();
            }
            boolean bl3 = bl = !bl2 && (string == null || string2 == null);
            if (bl) {
                AppletDesc appletDesc = launchDesc.getAppletDescriptor();
                URL uRL = BasicServiceImpl.getInstance().getCodeBase();
                URL uRL2 = appletDesc.getDocumentBase();
                if (uRL2 == null) {
                    uRL2 = uRL;
                }
                string = uRL != null ? uRL.toString() : null;
                String string3 = string2 = uRL2 != null ? uRL2.toString() : null;
                if (string2 == null) {
                    string2 = launchDesc.getCanonicalHome().toString();
                }
            }
            this.executeApplet(launchDesc, clazz, preloaderDelegate, localApplicationProperties, string, string2, bl);
        } else {
            this.executeApplication(launchDesc, localApplicationProperties, clazz, preloaderDelegate);
        }
    }

    private void executeApplication(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Class clazz, PreloaderDelegate preloaderDelegate) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        PerfLogger.setTime((String)"Begin executeApplication");
        String[] stringArray = null;
        if (launchDesc.getLaunchType() == 4) {
            stringArray = new String[]{localApplicationProperties.isExtensionInstalled() ? "uninstall" : "install"};
            localApplicationProperties.setExtensionInstalled(false);
            localApplicationProperties.setRebootNeeded(false);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        } else {
            SplashScreen.hide();
            if (Globals.getApplicationArgs() != null) {
                stringArray = Globals.getApplicationArgs();
            } else if (!launchDesc.isFXApp()) {
                stringArray = launchDesc.getApplicationDescriptor().getArguments();
            }
        }
        Object[] objectArray = new Object[]{stringArray};
        Class[] classArray = new Class[]{new String[0].getClass()};
        Method method = clazz.getMethod("main", classArray);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException(ResourceManager.getString((String)"launch.error.nonstaticmainmethod"));
        }
        method.setAccessible(true);
        PerfLogger.setTime((String)"End executeApplication (invoking App main)");
        PerfLogger.outputLog();
        Config.getHooks().preLaunch("javaws application", launchDesc.getCodebase().toString() + ": " + clazz.getName() + " " + ArrayUtil.arrayToString((String[])stringArray));
        try {
            Progress.get(null).handleEvent((PreloaderEvent)new AppInitEvent(2));
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        method.invoke(null, objectArray);
    }

    private void executeApplet(LaunchDesc launchDesc, Class clazz, PreloaderDelegate preloaderDelegate, LocalApplicationProperties localApplicationProperties, String string, String string2, boolean bl) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        try {
            Class<?> clazz2 = null;
            clazz2 = Class.forName("sun.plugin2.applet.viewer.JNLP2Viewer");
            SplashScreen.hide();
            Class[] classArray = new Class[]{new String[0].getClass()};
            Method method = clazz2.getMethod("main", classArray);
            method.setAccessible(true);
            URL uRL = launchDesc.getCanonicalHome();
            File file = null;
            try {
                file = DownloadEngine.getCachedFile((URL)uRL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (file != null) {
                Object[] objectArray;
                String[] stringArray = null;
                stringArray = !bl ? ((objectArray = SingleInstanceManager.getActionName()) != null && (objectArray.equals("-open") || objectArray.equals("-print")) ? new String[]{objectArray, SingleInstanceManager.getOpenPrintFilePath(), file.toString()} : (localApplicationProperties.isDraggedApplet() ? new String[]{"-draggedApplet", file.toString()} : new String[]{file.toString()})) : new String[]{"-codebase", string, "-documentbase", string2, file.toString()};
                objectArray = new Object[]{stringArray};
                DeployOfflineManager.setForcedOffline((boolean)false);
                method.invoke(null, objectArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AppletDesc appletDesc = launchDesc.getAppletDescriptor();
            int n = appletDesc.getWidth();
            int n2 = appletDesc.getHeight();
            Applet applet = null;
            applet = (Applet)clazz.newInstance();
            SplashScreen.hide();
            final JFrame jFrame = new JFrame();
            boolean bl2 = BrowserSupport.isWebBrowserSupported();
            AppletContainerCallback appletContainerCallback = new AppletContainerCallback(){

                public void showDocument(URL uRL) {
                    BrowserSupport.showDocument(uRL);
                }

                public void relativeResize(Dimension dimension) {
                    Dimension dimension2 = jFrame.getSize();
                    dimension2.width += dimension.width;
                    dimension2.height += dimension.height;
                    jFrame.setSize(dimension2);
                }
            };
            URL uRL = BasicServiceImpl.getInstance().getCodeBase();
            URL uRL2 = appletDesc.getDocumentBase();
            if (uRL2 == null) {
                uRL2 = uRL;
            }
            final AppletContainer appletContainer = new AppletContainer(appletContainerCallback, applet, appletDesc.getName(), uRL2, uRL, n, n2, appletDesc.getParameters());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    appletContainer.stopApplet();
                }
            });
            jFrame.setTitle(launchDesc.getInformation().getTitle());
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add("Center", appletContainer);
            jFrame.pack();
            Dimension dimension = appletContainer.getPreferredFrameSize(jFrame);
            jFrame.setSize(dimension);
            jFrame.getRootPane().revalidate();
            jFrame.getRootPane().repaint();
            jFrame.setResizable(false);
            if (!jFrame.isVisible()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jFrame.setVisible(true);
                    }
                });
            }
            Config.getHooks().preLaunch("javaws applet", appletDesc.getDocumentBase() + ": " + ArrayUtil.propertiesToString((Properties)appletDesc.getParameters()));
            appletContainer.startApplet();
        }
    }

    private void handleJnlpFileException(LaunchDesc launchDesc, Exception exception) throws ExitException {
        DownloadEngine.removeCachedResource((URL)launchDesc.getCanonicalHome(), null, null);
        throw new ExitException(exception, 3);
    }

    class CacheUpdateRequiredException
    extends Exception {
        public CacheUpdateRequiredException(String string) {
            super(string);
        }
    }
}

