/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.javaws.Globals;
import com.sun.javaws.Launcher;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.PreloaderDelegate;
import com.sun.javaws.ui.UpdateDialog;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.net.ssl.SSLHandshakeException;

public class LDUpdater {
    private LaunchDesc _ld = null;
    private boolean _updateAvailable;
    private boolean _updateDownloaded;
    private boolean _updateChecked;
    private boolean _checkAborted;
    private boolean _checkFaulted;
    private LocalApplicationProperties _lap = null;
    private volatile Thread backgroundUpdateThread = null;
    private Exception _exception = null;
    private int _numTasks = 0;
    private int _numTasksMax = 0;
    private boolean _checkDone;
    private RapidUpdateCheckerQueue queue = null;
    private static final String APPCONTEXT_LD_KEY = "deploy-mainlaunchdescinappcontext";
    private static int sequenceNumber = 0;
    static /* synthetic */ Class class$com$sun$javaws$jnl$LDUpdater;

    public LDUpdater(LaunchDesc launchDesc) {
        this._ld = launchDesc;
        this.setMainLaunchDescInAppContext();
    }

    public boolean isCheckAborted() {
        return this._checkAborted;
    }

    public boolean isUpdateAvailable() throws Exception {
        boolean bl = Environment.isJavaWebStart();
        if (this._ld.isHttps()) {
            return this.isUpdateAvailable(bl, true, false);
        }
        return this.isUpdateAvailable(bl, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpdateAvailable(boolean bl, boolean bl2, boolean bl3) throws Exception {
        LDUpdater lDUpdater = this;
        synchronized (lDUpdater) {
            if (this._updateChecked) {
                return this._updateAvailable;
            }
        }
        try {
            if (this._ld.isApplicationDescriptor()) {
                this.startUpdateCheck(bl, bl2, bl3);
            } else {
                this._updateAvailable = this.updateCheck(bl, bl2, bl3);
            }
            lDUpdater = this;
            synchronized (lDUpdater) {
                this._updateChecked = true;
                this._updateDownloaded = !this._updateAvailable;
            }
            if (this._ld.isInstaller() && this._updateAvailable && DownloadEngine.isBackgroundThread()) {
                this.setForceUpdateCheck();
            }
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            throw exception;
        }
        return this._updateAvailable;
    }

    public boolean isUpdateDownloaded() {
        return this._updateDownloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadUpdate(boolean bl) throws Exception {
        if (this._updateAvailable) {
            this.download(bl);
        }
        LDUpdater lDUpdater = this;
        synchronized (lDUpdater) {
            this._updateAvailable = false;
            this._updateDownloaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUpdateCheck(final boolean bl, final boolean bl2, final boolean bl3) throws Exception {
        int n;
        if (this._lap == null) {
            this._lap = Cache.getLocalApplicationProperties((URL)this._ld.getCanonicalHome());
        }
        if ((n = this._ld.getUpdate().getCheck()) == 2) {
            return;
        }
        int n2 = Config.getIntProperty((String)"deployment.javaws.update.timeout");
        final boolean[] blArray = new boolean[4];
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean bl5 = false;
                boolean bl22 = false;
                boolean bl32 = false;
                boolean bl4 = false;
                try {
                    if (LDUpdater.this.updateCheck(bl, bl2, bl3)) {
                        bl5 = true;
                        LDUpdater.this.setForceUpdateCheck();
                    }
                    bl22 = true;
                }
                catch (FailedDownloadingResourceException failedDownloadingResourceException) {
                    Throwable throwable;
                    if (LDUpdater.this._ld.isHttps() && (throwable = failedDownloadingResourceException.getWrappedException()) != null && throwable instanceof SSLHandshakeException) {
                        bl4 = true;
                    }
                    Trace.ignored((Throwable)failedDownloadingResourceException);
                    bl32 = LDUpdater.this.checkException(failedDownloadingResourceException);
                }
                catch (Exception exception) {
                    Trace.ignored((Throwable)exception);
                    bl32 = LDUpdater.this.checkException(exception);
                }
                boolean[] blArray2 = blArray;
                synchronized (blArray) {
                    blArray[0] = bl5;
                    blArray[1] = bl22;
                    blArray[2] = bl32;
                    blArray[3] = bl4;
                    blArray.notifyAll();
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    return;
                }
            }
        }, "" + this._ld.getLocation()).start();
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            while (!(blArray[1] || blArray[2] || blArray[3])) {
                try {
                    blArray.wait(n2);
                }
                catch (InterruptedException interruptedException) {
                    Trace.ignored((Throwable)interruptedException);
                }
                if (n != 1 || this._ld.isHttps()) continue;
            }
            this._checkFaulted = blArray[2];
            this._checkAborted = blArray[3];
            this._updateAvailable = blArray[0];
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (this._checkFaulted) {
                throw this._exception;
            }
            return;
        }
    }

    public synchronized boolean isBackgroundUpdateRunning() {
        return null != this.backgroundUpdateThread;
    }

    public void startBackgroundUpdateOpt() {
        if (!this._ld.getUpdate().isBackgroundCheck()) {
            return;
        }
        if (null != this.backgroundUpdateThread) {
            return;
        }
        this.startBackgroundUpdate();
    }

    public boolean needUpdatePerPolicy(PreloaderDelegate preloaderDelegate) throws ExitException {
        boolean bl = false;
        switch (this._ld.getUpdate().getPolicy()) {
            default: {
                bl = true;
                break;
            }
            case 1: {
                bl = UpdateDialog.showUpdateDialog(this._ld, preloaderDelegate);
                if (bl) break;
                Trace.println((String)"Start from cached after user chose not to update", (TraceLevel)TraceLevel.BASIC);
                this.startBackgroundUpdate();
                break;
            }
            case 2: {
                bl = UpdateDialog.showUpdateDialog(this._ld, preloaderDelegate);
                if (bl) break;
                Trace.println((String)"Exiting after user chose not to update", (TraceLevel)TraceLevel.BASIC);
                throw new ExitException(new LaunchDescException(this._ld, "User cancelled mandatory update - aborted", null), 3);
            }
        }
        return bl;
    }

    public boolean needUpdatePerPolicy() throws ExitException {
        return this.needUpdatePerPolicy(null);
    }

    private synchronized void startBackgroundUpdate() {
        if (null != this.backgroundUpdateThread) {
            return;
        }
        Trace.println((String)"LDUpdater: started background update check", (TraceLevel)TraceLevel.NETWORK);
        final ArrayList arrayList = this.buildBackgroundDownloadList();
        this.storeBackgroundListInAppContext(arrayList);
        this.backgroundUpdateThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    DownloadEngine.setBackgroundThread((boolean)true);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    boolean bl = false;
                    if (LDUpdater.this.updateCheck(false, true, false)) {
                        try {
                            LDUpdater.this.download(true);
                        }
                        catch (Exception exception) {
                            bl = true;
                            Trace.println((String)"LDUpdater: exception in background update download, set force update check to true", (TraceLevel)TraceLevel.NETWORK);
                            Trace.ignoredException((Exception)exception);
                            LDUpdater.this.setForceUpdateCheck();
                        }
                    }
                    if (!bl) {
                        LDUpdater.this.resetForceUpdateCheck();
                    }
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
                finally {
                    LDUpdater.this.removeBackgroundListInAppContext(arrayList);
                }
            }
        });
        this.backgroundUpdateThread.setName("Background Update Thread");
        this.backgroundUpdateThread.setPriority(1);
        this.backgroundUpdateThread.setDaemon(true);
        this.backgroundUpdateThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateCheck(boolean bl, boolean bl2, boolean bl3) throws Exception {
        Object object;
        int n;
        IconDesc[] iconDescArray;
        ResourcesDesc resourcesDesc;
        if (bl3 && this.queue == null) {
            this.queue = this.getQueue();
            if (this.queue == null) {
                bl3 = false;
            }
        }
        if (bl3) {
            Object object2;
            ResourcesDesc resourcesDesc2;
            URL uRL = this._ld.getLocation();
            if (uRL != null) {
                this.incrementTaskNum();
                this.queue.enqueue(new RapidUpdateChecker(uRL, 0));
            }
            if ((resourcesDesc2 = this._ld.getResources()) != null) {
                int n2;
                IconDesc[] iconDescArray2;
                object2 = resourcesDesc2.getLocalJarDescs();
                for (int i = 0; i < ((JARDesc[])object2).length; ++i) {
                    if (!bl2 && object2[i].isLazyDownload()) continue;
                    this.incrementTaskNum();
                    this.queue.enqueue(new RapidUpdateChecker(object2[i], 1));
                }
                if (bl && (iconDescArray2 = this._ld.getInformation().getIcons()) != null) {
                    for (n2 = 0; n2 < iconDescArray2.length; ++n2) {
                        this.incrementTaskNum();
                        this.queue.enqueue(new RapidUpdateChecker(iconDescArray2[n2], 2));
                    }
                }
                ArrayList arrayList = new ArrayList();
                this.getAllExtensions(resourcesDesc2, arrayList);
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    LaunchDesc launchDesc = ((ExtensionDesc)arrayList.get(n2)).getExtensionDesc();
                    this.incrementTaskNum();
                    new Thread((Runnable)new RapidUpdateChecker(launchDesc, 3), "Rapid Update Checker- " + LDUpdater.nextSequenceNumber()).start();
                }
            }
            object2 = this;
            synchronized (object2) {
                while (!this._checkDone && !this._updateAvailable) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.ignored((Throwable)interruptedException);
                        break;
                    }
                }
            }
            this.stopQueue();
            if (!this._updateAvailable && this._exception != null) {
                throw this._exception;
            }
            return this._updateAvailable;
        }
        URL uRL = this._ld.getLocation();
        if (uRL != null) {
            try {
                if (DownloadEngine.isUpdateAvailable((URL)uRL, null)) {
                    return true;
                }
            }
            catch (IOException iOException) {
                throw new FailedDownloadingResourceException(uRL, null, iOException);
            }
        }
        if ((resourcesDesc = this._ld.getResources()) == null) {
            return false;
        }
        JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
        for (int i = 0; i < jARDescArray.length; ++i) {
            if (!bl2 && jARDescArray[i].isLazyDownload() || !jARDescArray[i].getUpdater().isUpdateAvailable()) continue;
            return true;
        }
        if (bl && (iconDescArray = this._ld.getInformation().getIcons()) != null) {
            for (n = 0; n < iconDescArray.length; ++n) {
                object = iconDescArray[n].getLocation();
                String string = iconDescArray[n].getVersion();
                try {
                    if (!DownloadEngine.isUpdateAvailable((URL)object, (String)string)) continue;
                    Globals.setIconImageUpdated(true);
                    continue;
                }
                catch (IOException iOException) {
                    throw new FailedDownloadingResourceException((URL)object, null, iOException);
                }
            }
        }
        ArrayList arrayList = new ArrayList();
        this.getAllExtensions(resourcesDesc, arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            object = ((ExtensionDesc)arrayList.get(n)).getExtensionDesc();
            try {
                if (!((LaunchDesc)object).getUpdater().isUpdateAvailable(bl, bl2, bl3)) continue;
                return true;
            }
            catch (NullPointerException nullPointerException) {
                Trace.ignored((Throwable)nullPointerException);
            }
        }
        return false;
    }

    private void getAllExtensions(ResourcesDesc resourcesDesc, final ArrayList arrayList) {
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                arrayList.add(extensionDesc);
            }
        });
    }

    private void download(boolean bl) throws Exception, JNLPException {
        Object object;
        int n;
        LocalApplicationProperties localApplicationProperties;
        Object object2;
        URL uRL = this._ld.getLocation();
        boolean bl2 = DownloadEngine.isUpdateAvailable((URL)uRL, null);
        if (bl2) {
            object2 = DownloadEngine.getUpdatedFile((URL)uRL, null);
            if (!this._ld.hasIdenticalContent((File)object2)) {
                this._ld = LaunchDescFactory.buildDescriptor((File)object2, this._ld.getCodebase(), uRL, uRL);
            }
            if ((localApplicationProperties = Cache.getLocalApplicationProperties((URL)uRL)) != null) {
                Launcher.notifyLocalInstallHandler(this._ld, localApplicationProperties, true, true, null);
            }
        }
        if ((object2 = this._ld.getResources()) == null) {
            return;
        }
        localApplicationProperties = ((ResourcesDesc)object2).getLocalJarDescs();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl) {
            arrayList.addAll(Arrays.asList(localApplicationProperties));
        } else {
            for (n = 0; n < ((LocalApplicationProperties)localApplicationProperties).length; ++n) {
                if (localApplicationProperties[n].isLazyDownload()) continue;
                arrayList.add(localApplicationProperties[n]);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (ExtensionDesc[])arrayList.get(n);
            if (!object.getUpdater().isUpdateAvailable()) continue;
            object.getUpdater().downloadUpdate();
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (JARDesc)arrayList.get(n);
            if (!object.getUpdater().isUpdateDownloaded()) continue;
            object.getUpdater().updateCache();
        }
        IconDesc iconDesc = this._ld.getInformation().getIconLocation(48, 0);
        if (iconDesc != null) {
            try {
                DownloadEngine.getResource((URL)iconDesc.getLocation(), null, (String)iconDesc.getVersion(), null, (boolean)true, (int)1);
                Trace.println((String)("Downloaded " + iconDesc.getLocation()), (TraceLevel)TraceLevel.NETWORK);
            }
            catch (Exception exception) {
                Trace.ignored((Throwable)exception);
            }
        }
        object = ((ResourcesDesc)object2).getExtensionDescs();
        for (int i = 0; i < ((ExtensionDesc[])object).length; ++i) {
            LaunchDesc launchDesc = object[i].getExtensionDesc();
            URL uRL2 = launchDesc.getLocation();
            try {
                if (!launchDesc.getUpdater().isUpdateAvailable(false, bl, false)) continue;
                launchDesc.getUpdater().downloadUpdate(bl);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                Trace.ignored((Throwable)nullPointerException);
                continue;
            }
            catch (IOException iOException) {
                throw new FailedDownloadingResourceException(uRL2, null, iOException);
            }
        }
    }

    private void setForceUpdateCheck() {
        if (this._lap != null && !this._lap.forceUpdateCheck()) {
            this._lap.setForceUpdateCheck(true);
            try {
                this._lap.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    private void resetForceUpdateCheck() {
        if (this._lap != null && this._lap.forceUpdateCheck()) {
            this._lap.setForceUpdateCheck(false);
            try {
                this._lap.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    private ArrayList buildBackgroundDownloadList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ResourcesDesc resourcesDesc;
            URL uRL = this._ld.getLocation();
            if (uRL != null) {
                arrayList.add(uRL.toString());
            }
            if ((resourcesDesc = this._ld.getResources()) != null) {
                IconDesc[] iconDescArray;
                ExtensionDesc[] extensionDescArray = resourcesDesc.getExtensionDescs();
                for (int i = 0; i < extensionDescArray.length; ++i) {
                    URL uRL2 = extensionDescArray[i].getLocation();
                    if (uRL2 == null) continue;
                    arrayList.add(uRL2.toString());
                }
                JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
                if (jARDescArray != null) {
                    for (int i = 0; i < jARDescArray.length; ++i) {
                        URL uRL3 = jARDescArray[i].getLocation();
                        if (uRL3 == null) continue;
                        arrayList.add(uRL3.toString());
                    }
                }
                if ((iconDescArray = this._ld.getInformation().getIcons()) != null) {
                    for (int i = 0; i < iconDescArray.length; ++i) {
                        URL uRL4 = iconDescArray[i].getLocation();
                        if (uRL4 == null) continue;
                        arrayList.add(uRL4.toString());
                    }
                }
            }
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
        return arrayList;
    }

    private void storeBackgroundListInAppContext(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (string == null) continue;
            ToolkitStore.get().getAppContext().put((Object)("deploy-bg-" + string), (Object)"background");
        }
    }

    private void removeBackgroundListInAppContext(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (string == null) continue;
            ToolkitStore.get().getAppContext().remove((Object)("deploy-bg-" + string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextSequenceNumber() {
        Class clazz = class$com$sun$javaws$jnl$LDUpdater == null ? (class$com$sun$javaws$jnl$LDUpdater = LDUpdater.class$("com.sun.javaws.jnl.LDUpdater")) : class$com$sun$javaws$jnl$LDUpdater;
        synchronized (clazz) {
            return ++sequenceNumber;
        }
    }

    private LDUpdater getMainLDUpdater() {
        if (this._ld.isApplicationDescriptor()) {
            return this._ld.getUpdater();
        }
        LaunchDesc launchDesc = this.getMainLaunchDescFromAppContext();
        if (null != launchDesc) {
            return launchDesc.getUpdater();
        }
        return null;
    }

    private RapidUpdateCheckerQueue getQueue() {
        if (!this._ld.isApplicationDescriptor()) {
            LDUpdater lDUpdater = this.getMainLDUpdater();
            if (lDUpdater != null) {
                return lDUpdater.getQueue();
            }
            return null;
        }
        if (this.queue == null) {
            int n = this.getNumTasksMax();
            this.queue = new RapidUpdateCheckerQueue(n);
            new Thread((Runnable)this.queue, "Rapid Update Checker Queue").start();
        }
        return this.queue;
    }

    private void stopQueue() {
        if (!this._ld.isApplicationDescriptor()) {
            return;
        }
        if (this.queue != null) {
            this.queue.stop();
        }
    }

    private int getNumTasksMax() {
        if (this._numTasksMax != 0) {
            return this._numTasksMax;
        }
        if (this._ld.isApplicationDescriptor()) {
            this._numTasksMax = this._ld.getResources().getConcurrentDownloads();
            return this._numTasksMax;
        }
        LaunchDesc launchDesc = this.getMainLaunchDescFromAppContext();
        if (launchDesc != null) {
            return launchDesc.getUpdater().getNumTasksMax();
        }
        return 4;
    }

    private void setMainLaunchDescInAppContext() {
        if (this._ld.isApplicationDescriptor()) {
            ToolkitStore.get().getAppContext().put((Object)APPCONTEXT_LD_KEY, (Object)this._ld);
        }
    }

    private LaunchDesc getMainLaunchDescFromAppContext() {
        Object object = ToolkitStore.get().getAppContext().get((Object)APPCONTEXT_LD_KEY);
        if (null != object) {
            return (LaunchDesc)object;
        }
        return null;
    }

    private synchronized void incrementTaskNum() {
        ++this._numTasks;
    }

    private synchronized void notifyUpdate(boolean bl) {
        if (bl) {
            this._updateAvailable = true;
            this.notifyAll();
        } else if (--this._numTasks == 0) {
            this._checkDone = true;
            this.notifyAll();
        }
    }

    private synchronized void notifyException(Exception exception) {
        if (this._ld != null && this._ld.getInformation().supportsOfflineOperation()) {
            Trace.ignoredException((Exception)exception);
            return;
        }
        if (this._exception == null) {
            this._exception = exception;
        }
    }

    private boolean checkException(Exception exception) {
        Throwable throwable;
        return this._ld.getUpdate().getCheck() != 1 || !this._ld.getInformation().supportsOfflineOperation() || !(exception instanceof JNLPException) || !((throwable = ((JNLPException)exception).getWrappedException()) instanceof IOException);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RapidUpdateChecker
    implements Runnable {
        private static final int HOME_URL = 0;
        private static final int JAR_DESC = 1;
        private static final int ICON_DESC = 2;
        private static final int EXT_LD = 3;
        private Object target;
        private int type;
        private boolean update = false;

        private RapidUpdateChecker(Object object, int n) {
            this.target = object;
            this.type = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                switch (this.type) {
                    case 0: {
                        URL uRL = (URL)this.target;
                        Trace.println((String)("LDUpdater: update check for " + uRL), (TraceLevel)TraceLevel.NETWORK);
                        try {
                            this.update = DownloadEngine.isUpdateAvailable((URL)uRL, null);
                            return;
                        }
                        catch (IOException iOException) {
                            throw new FailedDownloadingResourceException(uRL, null, iOException);
                        }
                    }
                    case 1: {
                        JARDesc jARDesc = (JARDesc)this.target;
                        Trace.println((String)("LDUpdater: update check for " + jARDesc.getLocation()), (TraceLevel)TraceLevel.NETWORK);
                        this.update = jARDesc.getUpdater().isUpdateAvailable();
                        return;
                    }
                    case 2: {
                        IconDesc iconDesc = (IconDesc)this.target;
                        URL uRL = iconDesc.getLocation();
                        String string = iconDesc.getVersion();
                        try {
                            if (!DownloadEngine.isUpdateAvailable((URL)uRL, (String)string)) return;
                            Globals.setIconImageUpdated(true);
                            return;
                        }
                        catch (IOException iOException) {
                            throw new FailedDownloadingResourceException(uRL, null, iOException);
                        }
                    }
                    case 3: {
                        LaunchDesc launchDesc = (LaunchDesc)this.target;
                        Trace.println((String)("LDUpdater: update check for " + launchDesc.getLocation()), (TraceLevel)TraceLevel.NETWORK);
                        this.update = launchDesc.getUpdater().isUpdateAvailable();
                        return;
                    }
                }
                return;
            }
            catch (Exception exception) {
                LDUpdater.this.notifyException(exception);
                return;
            }
            finally {
                LDUpdater.this.notifyUpdate(this.update);
                LDUpdater.this.queue.decreaseNumTasks();
            }
        }
    }

    private class RapidUpdateCheckerQueue
    implements Runnable {
        private static final String RAPID_CHECK_THREAD_NAME = "Rapid Update Checker- ";
        private volatile boolean shouldStop;
        private final Object lock = new Object();
        private LinkedList workQueue = new LinkedList();
        private int nThreads = 0;
        private int nThreadsMax;

        private RapidUpdateCheckerQueue(int n) {
            this.nThreadsMax = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enqueue(Runnable runnable) {
            Object object = this.lock;
            synchronized (object) {
                this.workQueue.add(runnable);
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            this.shouldStop = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.shouldStop) {
                    Object object = this.lock;
                    synchronized (object) {
                        while (!this.shouldStop && this.workQueue.isEmpty()) {
                            try {
                                this.lock.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                    }
                    while (!this.shouldStop && !this.workQueue.isEmpty()) {
                        object = null;
                        Object object2 = this.lock;
                        synchronized (object2) {
                            object = (Runnable)this.workQueue.removeFirst();
                        }
                        object2 = this;
                        synchronized (object2) {
                            while (this.nThreads >= this.nThreadsMax) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                            }
                            ++this.nThreads;
                        }
                        new Thread((Runnable)object, RAPID_CHECK_THREAD_NAME + LDUpdater.nextSequenceNumber()).start();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private synchronized void decreaseNumTasks() {
            --this.nThreads;
            this.notifyAll();
        }
    }
}

