/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.security.cipher.CCMParameterSpec;
import iaik.utils.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class CCMParameters
extends AlgorithmParametersSpi {
    private byte[] c;
    private int b;
    private byte[] a;

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("associatedData: " + (this.c != null ? Util.toString(this.c) : "null") + "\n");
        stringBuffer.append("nonce: " + (this.a != null ? Util.toString(this.a) : "null") + "\n");
        stringBuffer.append("macLength: " + this.b + "\n");
        return stringBuffer.toString();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        block5: {
            try {
                ASN1Object aSN1Object = DerCoder.decode(byArray);
                if (aSN1Object.isA(ASN.SEQUENCE)) {
                    this.a = (byte[])aSN1Object.getComponentAt(0).getValue();
                    if (this.a.length < 7 || this.a.length > 13) {
                        throw new IOException("nonce length not between 7 and 13 bytes!");
                    }
                    this.b = ((BigInteger)aSN1Object.getComponentAt(1).getValue()).intValue();
                    if (this.b < 4 || this.b > 16) {
                        throw new IOException("Specified MAC-length not between 4 and 16 bytes!");
                    }
                    break block5;
                }
                throw new IOException("Cannot decode CCM params. Invalid ASN.1 type!");
            }
            catch (CodingException codingException) {
                throw new IOException("DER decoding error. " + codingException.toString());
            }
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof CCMParameterSpec) {
            CCMParameterSpec cCMParameterSpec = (CCMParameterSpec)algorithmParameterSpec;
            this.a = cCMParameterSpec.getNonce();
            this.b = cCMParameterSpec.getMacLength();
            this.c = cCMParameterSpec.getAssociatedData();
            return;
        }
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            this.a = ((IvParameterSpec)algorithmParameterSpec).getIV();
            if (this.a.length < 7 || this.a.length > 13) {
                throw new InvalidParameterSpecException("nonce length not between 7 and 13 bytes!");
            }
        } else {
            throw new InvalidParameterSpecException("Can not initialize from class " + algorithmParameterSpec.getClass().getName());
        }
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        CCMParameterSpec cCMParameterSpec;
        try {
            cCMParameterSpec = new CCMParameterSpec(-1L, this.c, this.a, this.b);
        }
        catch (Exception exception) {
            throw new InvalidParameterSpecException(exception.toString());
        }
        if (!cCMParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return cCMParameterSpec;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected byte[] engineGetEncoded() throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new OCTET_STRING(this.a));
        sEQUENCE.addComponent(new INTEGER(this.b));
        return DerCoder.encode(sEQUENCE);
    }

    public CCMParameters(byte[] byArray, byte[] byArray2, int n2) throws InvalidAlgorithmParameterException {
        this.a = byArray2;
        this.b = n2;
        this.c = byArray;
        if (n2 == -1) {
            n2 = 12;
        }
        if (n2 < 4 || n2 > 16) {
            throw new InvalidAlgorithmParameterException("Specified MAC-length not between 4 and 16 bytes!");
        }
    }

    public CCMParameters() throws InvalidAlgorithmParameterException {
        this(null, null, -1);
    }
}

