/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.internal;

import com.sun.jmx.remote.internal.IIOPProxy;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public final class IIOPHelper {
    private static final String IMPL_CLASS = "com.sun.jmx.remote.protocol.iiop.IIOPProxyImpl";
    private static final IIOPProxy proxy = AccessController.doPrivileged(new PrivilegedAction<IIOPProxy>(){

        @Override
        public IIOPProxy run() {
            try {
                Class<?> clazz = Class.forName(IIOPHelper.IMPL_CLASS, true, null);
                return (IIOPProxy)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (InstantiationException instantiationException) {
                throw new AssertionError((Object)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }
    });

    private IIOPHelper() {
    }

    public static boolean isAvailable() {
        return proxy != null;
    }

    private static void ensureAvailable() {
        if (proxy == null) {
            throw new AssertionError((Object)"Should not here");
        }
    }

    public static boolean isStub(Object object) {
        return proxy == null ? false : proxy.isStub(object);
    }

    public static Object getDelegate(Object object) {
        IIOPHelper.ensureAvailable();
        return proxy.getDelegate(object);
    }

    public static void setDelegate(Object object, Object object2) {
        IIOPHelper.ensureAvailable();
        proxy.setDelegate(object, object2);
    }

    public static Object getOrb(Object object) {
        IIOPHelper.ensureAvailable();
        return proxy.getOrb(object);
    }

    public static void connect(Object object, Object object2) throws RemoteException {
        IIOPHelper.ensureAvailable();
        proxy.connect(object, object2);
    }

    public static boolean isOrb(Object object) {
        IIOPHelper.ensureAvailable();
        return proxy.isOrb(object);
    }

    public static Object createOrb(String[] stringArray, Properties properties) {
        IIOPHelper.ensureAvailable();
        return proxy.createOrb(stringArray, properties);
    }

    public static Object stringToObject(Object object, String string) {
        IIOPHelper.ensureAvailable();
        return proxy.stringToObject(object, string);
    }

    public static String objectToString(Object object, Object object2) {
        IIOPHelper.ensureAvailable();
        return proxy.objectToString(object, object2);
    }

    public static <T> T narrow(Object object, Class<T> clazz) {
        IIOPHelper.ensureAvailable();
        return proxy.narrow(object, clazz);
    }

    public static void exportObject(Remote remote) throws RemoteException {
        IIOPHelper.ensureAvailable();
        proxy.exportObject(remote);
    }

    public static void unexportObject(Remote remote) throws NoSuchObjectException {
        IIOPHelper.ensureAvailable();
        proxy.unexportObject(remote);
    }

    public static Remote toStub(Remote remote) throws NoSuchObjectException {
        IIOPHelper.ensureAvailable();
        return proxy.toStub(remote);
    }
}

