/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.sctp;

import com.sun.nio.sctp.SctpSocketOption;
import java.net.SocketAddress;
import sun.nio.ch.SctpStdSocketOption;

public class SctpStandardSocketOptions {
    public static final SctpSocketOption<Boolean> SCTP_DISABLE_FRAGMENTS = new SctpStdSocketOption<Boolean>("SCTP_DISABLE_FRAGMENTS", Boolean.class, 1);
    public static final SctpSocketOption<Boolean> SCTP_EXPLICIT_COMPLETE = new SctpStdSocketOption<Boolean>("SCTP_EXPLICIT_COMPLETE", Boolean.class, 2);
    public static final SctpSocketOption<Integer> SCTP_FRAGMENT_INTERLEAVE = new SctpStdSocketOption<Integer>("SCTP_FRAGMENT_INTERLEAVE", Integer.class, 3);
    public static final SctpSocketOption<InitMaxStreams> SCTP_INIT_MAXSTREAMS = new SctpStdSocketOption<InitMaxStreams>("SCTP_INIT_MAXSTREAMS", InitMaxStreams.class);
    public static final SctpSocketOption<Boolean> SCTP_NODELAY = new SctpStdSocketOption<Boolean>("SCTP_NODELAY", Boolean.class, 4);
    public static final SctpSocketOption<SocketAddress> SCTP_PRIMARY_ADDR = new SctpStdSocketOption<SocketAddress>("SCTP_PRIMARY_ADDR", SocketAddress.class);
    public static final SctpSocketOption<SocketAddress> SCTP_SET_PEER_PRIMARY_ADDR = new SctpStdSocketOption<SocketAddress>("SCTP_SET_PEER_PRIMARY_ADDR", SocketAddress.class);
    public static final SctpSocketOption<Integer> SO_SNDBUF = new SctpStdSocketOption<Integer>("SO_SNDBUF", Integer.class, 5);
    public static final SctpSocketOption<Integer> SO_RCVBUF = new SctpStdSocketOption<Integer>("SO_RCVBUF", Integer.class, 6);
    public static final SctpSocketOption<Integer> SO_LINGER = new SctpStdSocketOption<Integer>("SO_LINGER", Integer.class, 7);

    private SctpStandardSocketOptions() {
    }

    public static class InitMaxStreams {
        private int maxInStreams;
        private int maxOutStreams;

        private InitMaxStreams(int n, int n2) {
            this.maxInStreams = n;
            this.maxOutStreams = n2;
        }

        public static InitMaxStreams create(int n, int n2) {
            if (n2 < 0 || n2 > 65535) {
                throw new IllegalArgumentException("Invalid maxOutStreams value");
            }
            if (n < 0 || n > 65535) {
                throw new IllegalArgumentException("Invalid maxInStreams value");
            }
            return new InitMaxStreams(n, n2);
        }

        public int maxInStreams() {
            return this.maxInStreams;
        }

        public int maxOutStreams() {
            return this.maxOutStreams;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.toString()).append(" [");
            stringBuilder.append("maxInStreams:").append(this.maxInStreams);
            stringBuilder.append("maxOutStreams:").append(this.maxOutStreams).append("]");
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof InitMaxStreams) {
                InitMaxStreams initMaxStreams = (InitMaxStreams)object;
                if (this.maxInStreams == initMaxStreams.maxInStreams && this.maxOutStreams == initMaxStreams.maxOutStreams) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int n = 7 ^ this.maxInStreams ^ this.maxOutStreams;
            return n;
        }
    }
}

