/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import java.lang.reflect.Modifier;

public class VerifyAccess {
    private static final int PACKAGE_ONLY = 0;
    private static final int ALL_ACCESS_MODES = 7;
    private static final boolean ALLOW_NESTMATE_ACCESS = false;

    private VerifyAccess() {
    }

    public static boolean isMemberAccessible(Class<?> clazz, Class<?> clazz2, int n, Class<?> clazz3) {
        if (clazz != clazz2) {
            if (!VerifyAccess.isClassAccessible(clazz, clazz3)) {
                return false;
            }
            if ((n & 0xF) == 12 && !VerifyAccess.isRelatedClass(clazz, clazz3)) {
                return VerifyAccess.isSamePackage(clazz2, clazz3);
            }
        }
        if (clazz2 == clazz3) {
            return true;
        }
        switch (n & 7) {
            case 1: {
                if (clazz != clazz2) {
                    return true;
                }
                return VerifyAccess.isClassAccessible(clazz, clazz3);
            }
            case 4: {
                return VerifyAccess.isSamePackage(clazz2, clazz3) || VerifyAccess.isPublicSuperClass(clazz2, clazz3);
            }
            case 0: {
                return VerifyAccess.isSamePackage(clazz2, clazz3);
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalArgumentException("bad modifiers: " + Modifier.toString(n));
    }

    static boolean isRelatedClass(Class<?> clazz, Class<?> clazz2) {
        return clazz == clazz2 || clazz.isAssignableFrom(clazz2) || clazz2.isAssignableFrom(clazz);
    }

    static boolean isPublicSuperClass(Class<?> clazz, Class<?> clazz2) {
        return Modifier.isPublic(clazz.getModifiers()) && clazz.isAssignableFrom(clazz2);
    }

    public static boolean isClassAccessible(Class<?> clazz, Class<?> clazz2) {
        int n = clazz.getModifiers();
        if (Modifier.isPublic(n)) {
            return true;
        }
        return VerifyAccess.isSamePackage(clazz2, clazz);
    }

    public static boolean isSamePackage(Class<?> clazz, Class<?> clazz2) {
        assert (!clazz.isArray() && !clazz2.isArray());
        if (clazz == clazz2) {
            return true;
        }
        if (!VerifyAccess.loadersAreRelated(clazz.getClassLoader(), clazz2.getClassLoader(), false)) {
            return false;
        }
        String string = clazz.getName();
        String string2 = clazz2.getName();
        int n = string.lastIndexOf(46);
        if (n != string2.lastIndexOf(46)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String getPackageName(Class<?> clazz) {
        assert (!clazz.isArray());
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static boolean isSamePackageMember(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        if (!VerifyAccess.isSamePackage(clazz, clazz2)) {
            return false;
        }
        return VerifyAccess.getOutermostEnclosingClass(clazz) == VerifyAccess.getOutermostEnclosingClass(clazz2);
    }

    private static Class<?> getOutermostEnclosingClass(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        Class<?> clazz3 = clazz;
        while ((clazz3 = clazz3.getEnclosingClass()) != null) {
            clazz2 = clazz3;
        }
        return clazz2;
    }

    private static boolean loadersAreRelated(ClassLoader classLoader, ClassLoader classLoader2, boolean bl) {
        ClassLoader classLoader3;
        if (classLoader == classLoader2 || classLoader == null || classLoader2 == null && !bl) {
            return true;
        }
        for (classLoader3 = classLoader2; classLoader3 != null; classLoader3 = classLoader3.getParent()) {
            if (classLoader3 != classLoader) continue;
            return true;
        }
        if (bl) {
            return false;
        }
        for (classLoader3 = classLoader; classLoader3 != null; classLoader3 = classLoader3.getParent()) {
            if (classLoader3 != classLoader2) continue;
            return true;
        }
        return false;
    }

    public static boolean classLoaderIsAncestor(Class<?> clazz, Class<?> clazz2) {
        return VerifyAccess.loadersAreRelated(clazz.getClassLoader(), clazz2.getClassLoader(), true);
    }
}

