/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.xmlimpl;

import java.util.ArrayList;
import sun.org.mozilla.javascript.internal.Callable;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.Function;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.Undefined;
import sun.org.mozilla.javascript.internal.xml.XMLObject;
import sun.org.mozilla.javascript.internal.xmlimpl.XML;
import sun.org.mozilla.javascript.internal.xmlimpl.XMLLibImpl;
import sun.org.mozilla.javascript.internal.xmlimpl.XMLName;
import sun.org.mozilla.javascript.internal.xmlimpl.XMLObjectImpl;
import sun.org.mozilla.javascript.internal.xmlimpl.XmlNode;

class XMLList
extends XMLObjectImpl
implements Function {
    static final long serialVersionUID = -4543618751670781135L;
    private XmlNode.InternalList _annos = new XmlNode.InternalList();
    private XMLObjectImpl targetObject = null;
    private XmlNode.QName targetProperty = null;

    XMLList(XMLLibImpl xMLLibImpl, Scriptable scriptable, XMLObject xMLObject) {
        super(xMLLibImpl, scriptable, xMLObject);
    }

    XmlNode.InternalList getNodeList() {
        return this._annos;
    }

    void setTargets(XMLObjectImpl xMLObjectImpl, XmlNode.QName qName) {
        this.targetObject = xMLObjectImpl;
        this.targetProperty = qName;
    }

    private XML getXmlFromAnnotation(int n) {
        return this.getXML(this._annos, n);
    }

    @Override
    XML getXML() {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0);
        }
        return null;
    }

    private void internalRemoveFromList(int n) {
        this._annos.remove(n);
    }

    void replace(int n, XML xML) {
        if (n < this.length()) {
            XmlNode.InternalList internalList = new XmlNode.InternalList();
            internalList.add(this._annos, 0, n);
            internalList.add(xML);
            internalList.add(this._annos, n + 1, this.length());
            this._annos = internalList;
        }
    }

    private void insert(int n, XML xML) {
        if (n < this.length()) {
            XmlNode.InternalList internalList = new XmlNode.InternalList();
            internalList.add(this._annos, 0, n);
            internalList.add(xML);
            internalList.add(this._annos, n, this.length());
            this._annos = internalList;
        }
    }

    @Override
    public String getClassName() {
        return "XMLList";
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        if (n >= 0 && n < this.length()) {
            return this.getXmlFromAnnotation(n);
        }
        return Scriptable.NOT_FOUND;
    }

    @Override
    boolean hasXMLProperty(XMLName xMLName) {
        boolean bl = false;
        String string = xMLName.localName();
        if (this.getPropertyList(xMLName).length() > 0 || this.getMethod(string) != NOT_FOUND) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return 0 <= n && n < this.length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void putXMLProperty(XMLName xMLName, Object object) {
        if (object == null) {
            object = "null";
        } else if (object instanceof Undefined) {
            object = "undefined";
        }
        if (this.length() > 1) {
            throw ScriptRuntime.typeError("Assignment to lists with more than one item is not supported");
        }
        if (this.length() == 0) {
            if (this.targetObject == null || this.targetProperty == null || this.targetProperty.getLocalName() == null || this.targetProperty.getLocalName().length() <= 0) throw ScriptRuntime.typeError("Assignment to empty XMLList without targets not supported");
            XML xML = this.newTextElementXML(null, this.targetProperty, null);
            this.addToList(xML);
            if (xMLName.isAttributeName()) {
                this.setAttribute(xMLName, object);
            } else {
                XML xML2 = this.item(0);
                xML2.putXMLProperty(xMLName, object);
                this.replace(0, this.item(0));
            }
            XMLName xMLName2 = XMLName.formProperty(this.targetProperty.getNamespace().getUri(), this.targetProperty.getLocalName());
            this.targetObject.putXMLProperty(xMLName2, this);
            return;
        } else if (xMLName.isAttributeName()) {
            this.setAttribute(xMLName, object);
            return;
        } else {
            XML xML = this.item(0);
            xML.putXMLProperty(xMLName, object);
            this.replace(0, this.item(0));
            if (this.targetObject == null || this.targetProperty == null || this.targetProperty.getLocalName() == null) return;
            XMLName xMLName3 = XMLName.formProperty(this.targetProperty.getNamespace().getUri(), this.targetProperty.getLocalName());
            this.targetObject.putXMLProperty(xMLName3, this);
        }
    }

    @Override
    Object getXMLProperty(XMLName xMLName) {
        return this.getPropertyList(xMLName);
    }

    private void replaceNode(XML xML, XML xML2) {
        xML.replaceWith(xML2);
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        XML xML;
        XMLObject xMLObject;
        Object object2 = Undefined.instance;
        if (object == null) {
            object = "null";
        } else if (object instanceof Undefined) {
            object = "undefined";
        }
        if (object instanceof XMLObject) {
            xMLObject = (XMLObject)object;
        } else if (this.targetProperty == null) {
            xMLObject = this.newXMLFromJs(object.toString());
        } else {
            xMLObject = this.item(n);
            if (xMLObject == null) {
                xML = this.item(0);
                xMLObject = xML == null ? this.newTextElementXML(null, this.targetProperty, null) : xML.copy();
            }
            ((XML)xMLObject).setChildren(object);
        }
        object2 = n < this.length() ? this.item(n).parent() : (this.length() == 0 ? (this.targetObject != null ? this.targetObject.getXML() : this.parent()) : this.parent());
        if (object2 instanceof XML) {
            xML = (XML)object2;
            if (n < this.length()) {
                XMLList xMLList;
                XML xML2 = this.getXmlFromAnnotation(n);
                if (xMLObject instanceof XML) {
                    this.replaceNode(xML2, (XML)xMLObject);
                    this.replace(n, xML2);
                } else if (xMLObject instanceof XMLList && (xMLList = (XMLList)xMLObject).length() > 0) {
                    int n2 = xML2.childIndex();
                    this.replaceNode(xML2, xMLList.item(0));
                    this.replace(n, xMLList.item(0));
                    for (int i = 1; i < xMLList.length(); ++i) {
                        xML.insertChildAfter(xML.getXmlChild(n2), xMLList.item(i));
                        ++n2;
                        this.insert(n + i, xMLList.item(i));
                    }
                }
            } else {
                xML.appendChild(xMLObject);
                this.addToList(xML.getXmlChild(n));
            }
        } else if (n < this.length()) {
            XMLList xMLList;
            xML = this.getXML(this._annos, n);
            if (xMLObject instanceof XML) {
                this.replaceNode(xML, (XML)xMLObject);
                this.replace(n, xML);
            } else if (xMLObject instanceof XMLList && (xMLList = (XMLList)xMLObject).length() > 0) {
                this.replaceNode(xML, xMLList.item(0));
                this.replace(n, xMLList.item(0));
                for (int i = 1; i < xMLList.length(); ++i) {
                    this.insert(n + i, xMLList.item(i));
                }
            }
        } else {
            this.addToList(xMLObject);
        }
    }

    private XML getXML(XmlNode.InternalList internalList, int n) {
        if (n >= 0 && n < this.length()) {
            return this.xmlFromNode(internalList.item(n));
        }
        return null;
    }

    @Override
    void deleteXMLProperty(XMLName xMLName) {
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            if (!xML.isElement()) continue;
            xML.deleteXMLProperty(xMLName);
        }
    }

    @Override
    public void delete(int n) {
        if (n >= 0 && n < this.length()) {
            XML xML = this.getXmlFromAnnotation(n);
            xML.remove();
            this.internalRemoveFromList(n);
        }
    }

    @Override
    public Object[] getIds() {
        Object[] objectArray;
        if (this.isPrototype()) {
            objectArray = new Object[]{};
        } else {
            objectArray = new Object[this.length()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = i;
            }
        }
        return objectArray;
    }

    public Object[] getIdsForDebug() {
        return this.getIds();
    }

    void remove() {
        int n = this.length();
        for (int i = n - 1; i >= 0; --i) {
            XML xML = this.getXmlFromAnnotation(i);
            if (xML == null) continue;
            xML.remove();
            this.internalRemoveFromList(i);
        }
    }

    XML item(int n) {
        return this._annos != null ? this.getXmlFromAnnotation(n) : this.createEmptyXML();
    }

    private void setAttribute(XMLName xMLName, Object object) {
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            xML.setAttribute(xMLName, object);
        }
    }

    void addToList(Object object) {
        this._annos.addToList(object);
    }

    @Override
    XMLList child(int n) {
        XMLList xMLList = this.newXMLList();
        for (int i = 0; i < this.length(); ++i) {
            xMLList.addToList(this.getXmlFromAnnotation(i).child(n));
        }
        return xMLList;
    }

    @Override
    XMLList child(XMLName xMLName) {
        XMLList xMLList = this.newXMLList();
        for (int i = 0; i < this.length(); ++i) {
            xMLList.addToList(this.getXmlFromAnnotation(i).child(xMLName));
        }
        return xMLList;
    }

    @Override
    void addMatches(XMLList xMLList, XMLName xMLName) {
        for (int i = 0; i < this.length(); ++i) {
            this.getXmlFromAnnotation(i).addMatches(xMLList, xMLName);
        }
    }

    @Override
    XMLList children() {
        ArrayList<XML> arrayList = new ArrayList<XML>();
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            if (xML == null) continue;
            XMLList xMLList = xML.children();
            int n = xMLList.length();
            for (int j = 0; j < n; ++j) {
                arrayList.add(xMLList.item(j));
            }
        }
        XMLList xMLList = this.newXMLList();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            xMLList.addToList(arrayList.get(i));
        }
        return xMLList;
    }

    @Override
    XMLList comments() {
        XMLList xMLList = this.newXMLList();
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            xMLList.addToList(xML.comments());
        }
        return xMLList;
    }

    @Override
    XMLList elements(XMLName xMLName) {
        XMLList xMLList = this.newXMLList();
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            xMLList.addToList(xML.elements(xMLName));
        }
        return xMLList;
    }

    @Override
    boolean contains(Object object) {
        boolean bl = false;
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            if (!xML.equivalentXml(object)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    XMLObjectImpl copy() {
        XMLList xMLList = this.newXMLList();
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            xMLList.addToList(xML.copy());
        }
        return xMLList;
    }

    @Override
    boolean hasOwnProperty(XMLName xMLName) {
        if (this.isPrototype()) {
            String string = xMLName.localName();
            return this.findPrototypeId(string) != 0;
        }
        return this.getPropertyList(xMLName).length() > 0;
    }

    @Override
    boolean hasComplexContent() {
        boolean bl;
        int n = this.length();
        if (n == 0) {
            bl = false;
        } else if (n == 1) {
            bl = this.getXmlFromAnnotation(0).hasComplexContent();
        } else {
            bl = false;
            for (int i = 0; i < n; ++i) {
                XML xML = this.getXmlFromAnnotation(i);
                if (!xML.isElement()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Override
    boolean hasSimpleContent() {
        if (this.length() == 0) {
            return true;
        }
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).hasSimpleContent();
        }
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            if (!xML.isElement()) continue;
            return false;
        }
        return true;
    }

    @Override
    int length() {
        int n = 0;
        if (this._annos != null) {
            n = this._annos.length();
        }
        return n;
    }

    @Override
    void normalize() {
        for (int i = 0; i < this.length(); ++i) {
            this.getXmlFromAnnotation(i).normalize();
        }
    }

    @Override
    Object parent() {
        if (this.length() == 0) {
            return Undefined.instance;
        }
        XML xML = null;
        for (int i = 0; i < this.length(); ++i) {
            Object object = this.getXmlFromAnnotation(i).parent();
            if (!(object instanceof XML)) {
                return Undefined.instance;
            }
            XML xML2 = (XML)object;
            if (i == 0) {
                xML = xML2;
                continue;
            }
            if (xML.is(xML2)) continue;
            return Undefined.instance;
        }
        return xML;
    }

    @Override
    XMLList processingInstructions(XMLName xMLName) {
        XMLList xMLList = this.newXMLList();
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            xMLList.addToList(xML.processingInstructions(xMLName));
        }
        return xMLList;
    }

    @Override
    boolean propertyIsEnumerable(Object object) {
        long l;
        if (object instanceof Integer) {
            l = ((Integer)object).intValue();
        } else if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            l = (long)d;
            if ((double)l != d) {
                return false;
            }
            if (l == 0L && 1.0 / d < 0.0) {
                return false;
            }
        } else {
            String string = ScriptRuntime.toString(object);
            l = ScriptRuntime.testUint32String(string);
        }
        return 0L <= l && l < (long)this.length();
    }

    @Override
    XMLList text() {
        XMLList xMLList = this.newXMLList();
        for (int i = 0; i < this.length(); ++i) {
            xMLList.addToList(this.getXmlFromAnnotation(i).text());
        }
        return xMLList;
    }

    @Override
    public String toString() {
        if (this.hasSimpleContent()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.length(); ++i) {
                XML xML = this.getXmlFromAnnotation(i);
                if (xML.isComment() || xML.isProcessingInstruction()) continue;
                stringBuffer.append(xML.toString());
            }
            return stringBuffer.toString();
        }
        return this.toXMLString();
    }

    @Override
    String toSource(int n) {
        return this.toXMLString();
    }

    @Override
    String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.length(); ++i) {
            if (this.getProcessor().isPrettyPrinting() && i != 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(this.getXmlFromAnnotation(i).toXMLString());
        }
        return stringBuffer.toString();
    }

    @Override
    Object valueOf() {
        return this;
    }

    @Override
    boolean equivalentXml(Object object) {
        XMLList xMLList;
        boolean bl = false;
        if (object instanceof Undefined && this.length() == 0) {
            bl = true;
        } else if (this.length() == 1) {
            bl = this.getXmlFromAnnotation(0).equivalentXml(object);
        } else if (object instanceof XMLList && (xMLList = (XMLList)object).length() == this.length()) {
            bl = true;
            for (int i = 0; i < this.length(); ++i) {
                if (this.getXmlFromAnnotation(i).equivalentXml(xMLList.getXmlFromAnnotation(i))) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private XMLList getPropertyList(XMLName xMLName) {
        XMLList xMLList = this.newXMLList();
        XmlNode.QName qName = null;
        if (!xMLName.isDescendants() && !xMLName.isAttributeName()) {
            qName = xMLName.toQname();
        }
        xMLList.setTargets(this, qName);
        for (int i = 0; i < this.length(); ++i) {
            xMLList.addToList(this.getXmlFromAnnotation(i).getPropertyList(xMLName));
        }
        return xMLList;
    }

    private Object applyOrCall(boolean bl, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        String string;
        String string2 = string = bl ? "apply" : "call";
        if (!(scriptable2 instanceof XMLList) || ((XMLList)scriptable2).targetProperty == null) {
            throw ScriptRuntime.typeError1("msg.isnt.function", string);
        }
        return ScriptRuntime.applyOrCall(bl, context, scriptable, scriptable2, objectArray);
    }

    @Override
    protected Object jsConstructor(Context context, boolean bl, Object[] objectArray) {
        if (objectArray.length == 0) {
            return this.newXMLList();
        }
        Object object = objectArray[0];
        if (!bl && object instanceof XMLList) {
            return object;
        }
        return this.newXMLListFrom(object);
    }

    @Override
    public Scriptable getExtraMethodSource(Context context) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0);
        }
        return null;
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (this.targetProperty == null) {
            throw ScriptRuntime.notFunctionError(this);
        }
        String string = this.targetProperty.getLocalName();
        boolean bl = string.equals("apply");
        if (bl || string.equals("call")) {
            return this.applyOrCall(bl, context, scriptable, scriptable2, objectArray);
        }
        Callable callable = ScriptRuntime.getElemFunctionAndThis(this, string, context);
        ScriptRuntime.lastStoredScriptable(context);
        return callable.call(context, scriptable, scriptable2, objectArray);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        throw ScriptRuntime.typeError1("msg.not.ctor", "XMLList");
    }
}

